/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.servers.Server;

public class BeanConfig {
    public static final String DEFAULT_MEDIA_TYPE = "application/json";
    String[] schemes;
    String title;
    String version;
    String licenseUrl;
    String license;
    Info info;
    String host;
    String basePath;
    String defaultConsumes = "application/json";
    String defaultProduces = "application/json";

    public String[] getSchemes() {
        return this.schemes;
    }

    public void setSchemes(String[] schemes) {
        this.schemes = schemes;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        if (basePath != null && !basePath.isEmpty()) {
            this.basePath = !basePath.startsWith("/") ? "/" + basePath : basePath;
        }
    }

    public String getDefaultConsumes() {
        return this.defaultConsumes;
    }

    public void setDefaultConsumes(String defaultConsumes) {
        this.defaultConsumes = defaultConsumes;
    }

    public String getDefaultProduces() {
        return this.defaultProduces;
    }

    public void setDefaultProduces(String defaultProduces) {
        this.defaultProduces = defaultProduces;
    }

    public OpenAPI configure(OpenAPI openApi) {
        if (this.info != null) {
            openApi.setInfo(this.info);
        }
        for (String scheme : this.schemes) {
            Server server = new Server().url(scheme + "://" + this.host + this.basePath);
            openApi.addServersItem(server);
        }
        return openApi;
    }

    public boolean isOpenApi3() {
        return this.version == null || this.version.startsWith("3");
    }
}

