/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo4.api.batch;

import java.util.Map;
import org.apache.camel.component.olingo4.api.batch.Olingo4BatchRequest;

public class Olingo4BatchQueryRequest
extends Olingo4BatchRequest {
    private Map<String, String> queryParams;

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public static Olingo4BatchQueryRequestBuilder resourcePath(String resourcePath) {
        if (resourcePath == null) {
            throw new IllegalArgumentException("resourcePath");
        }
        return new Olingo4BatchQueryRequestBuilder().resourcePath(resourcePath);
    }

    @Override
    public String toString() {
        return "Batch Query Request{ " + this.resourceUri + "/" + this.resourcePath + ", headers=" + this.headers + ", queryParams=" + this.queryParams + '}';
    }

    public static class Olingo4BatchQueryRequestBuilder {
        private Olingo4BatchQueryRequest request = new Olingo4BatchQueryRequest();

        public Olingo4BatchQueryRequest build() {
            if (this.request.resourcePath == null) {
                throw new IllegalArgumentException("Null resourcePath");
            }
            return this.request;
        }

        public Olingo4BatchQueryRequestBuilder resourceUri(String resourceUri) {
            this.request.resourceUri = resourceUri;
            return this;
        }

        public Olingo4BatchQueryRequestBuilder resourcePath(String resourcePath) {
            this.request.resourcePath = resourcePath;
            return this;
        }

        public Olingo4BatchQueryRequestBuilder headers(Map<String, String> headers) {
            this.request.headers = headers;
            return this;
        }

        public Olingo4BatchQueryRequestBuilder queryParams(Map<String, String> queryParams) {
            this.request.queryParams = queryParams;
            return this;
        }
    }
}

