/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.irc.IrcConfiguration;
import org.apache.camel.component.irc.IrcEndpoint;
import org.apache.camel.component.irc.IrcExchange;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.schwering.irc.lib.IRCConnection;
import org.schwering.irc.lib.IRCEventAdapter;
import org.schwering.irc.lib.IRCEventListener;
import org.schwering.irc.lib.IRCModeParser;
import org.schwering.irc.lib.IRCUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IrcConsumer
extends DefaultConsumer<IrcExchange> {
    private static final transient Log LOG = LogFactory.getLog(IrcConsumer.class);
    private final IrcConfiguration configuration;
    private final IrcEndpoint endpoint;
    private final IRCConnection connection;
    private FilteredIRCEventAdapter listener;

    public IrcConsumer(IrcEndpoint endpoint, Processor processor, IRCConnection connection) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.connection = connection;
        this.configuration = endpoint.getConfiguration();
    }

    protected void doStop() throws Exception {
        String target = this.endpoint.getConfiguration().getTarget();
        this.connection.doPart(target);
        this.connection.removeIRCEventListener((IRCEventListener)this.listener);
        super.doStop();
    }

    protected void doStart() throws Exception {
        super.doStart();
        String target = this.endpoint.getConfiguration().getTarget();
        this.connection.addIRCEventListener((IRCEventListener)new FilteredIRCEventAdapter(target));
        LOG.debug((Object)("joining: " + target));
        this.connection.doJoin(target);
    }

    public IRCConnection getConnection() {
        return this.connection;
    }

    class FilteredIRCEventAdapter
    extends IRCEventAdapter {
        final String target;

        public FilteredIRCEventAdapter(String target) {
            this.target = target;
        }

        public void onNick(IRCUser user, String newNick) {
            if (IrcConsumer.this.configuration.isOnNick()) {
                IrcExchange exchange = IrcConsumer.this.endpoint.createOnNickExchange(user, newNick);
                try {
                    IrcConsumer.this.getProcessor().process((Exchange)exchange);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void onQuit(IRCUser user, String msg) {
            if (IrcConsumer.this.configuration.isOnQuit()) {
                IrcExchange exchange = IrcConsumer.this.endpoint.createOnQuitExchange(user, msg);
                try {
                    IrcConsumer.this.getProcessor().process((Exchange)exchange);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void onJoin(String channel, IRCUser user) {
            if (IrcConsumer.this.configuration.isOnJoin() && channel.equals(IrcConsumer.this.configuration.getTarget())) {
                IrcExchange exchange = IrcConsumer.this.endpoint.createOnJoinExchange(channel, user);
                try {
                    IrcConsumer.this.getProcessor().process((Exchange)exchange);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void onKick(String channel, IRCUser user, String passiveNick, String msg) {
            if (IrcConsumer.this.configuration.isOnKick() && channel.equals(IrcConsumer.this.configuration.getTarget())) {
                IrcExchange exchange = IrcConsumer.this.endpoint.createOnKickExchange(channel, user, passiveNick, msg);
                try {
                    IrcConsumer.this.getProcessor().process((Exchange)exchange);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void onMode(String channel, IRCUser user, IRCModeParser modeParser) {
            if (IrcConsumer.this.configuration.isOnMode() && channel.equals(IrcConsumer.this.configuration.getTarget())) {
                IrcExchange exchange = IrcConsumer.this.endpoint.createOnModeExchange(channel, user, modeParser);
                try {
                    IrcConsumer.this.getProcessor().process((Exchange)exchange);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void onPart(String channel, IRCUser user, String msg) {
            if (IrcConsumer.this.configuration.isOnPart() && channel.equals(IrcConsumer.this.configuration.getTarget())) {
                IrcExchange exchange = IrcConsumer.this.endpoint.createOnPartExchange(channel, user, msg);
                try {
                    IrcConsumer.this.getProcessor().process((Exchange)exchange);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void onTopic(String channel, IRCUser user, String topic) {
            if (IrcConsumer.this.configuration.isOnTopic() && channel.equals(IrcConsumer.this.configuration.getTarget())) {
                IrcExchange exchange = IrcConsumer.this.endpoint.createOnTopicExchange(channel, user, topic);
                try {
                    IrcConsumer.this.getProcessor().process((Exchange)exchange);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void onPrivmsg(String target, IRCUser user, String msg) {
            if (IrcConsumer.this.configuration.isOnPrivmsg() && target.equals(IrcConsumer.this.configuration.getTarget())) {
                IrcExchange exchange = IrcConsumer.this.endpoint.createOnPrivmsgExchange(target, user, msg);
                try {
                    IrcConsumer.this.getProcessor().process((Exchange)exchange);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

