/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.remote.cluster;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Service;
import org.apache.camel.cluster.CamelClusterMember;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.infinispan.InfinispanUtil;
import org.apache.camel.component.infinispan.cluster.InfinispanClusterView;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteConfiguration;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteManager;
import org.apache.camel.component.infinispan.remote.cluster.InfinispanRemoteClusterConfiguration;
import org.apache.camel.component.infinispan.remote.cluster.InfinispanRemoteClusterService;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.function.Predicates;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryExpiredEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanRemoteClusterView
extends InfinispanClusterView {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanRemoteClusterService.class);
    private final InfinispanRemoteClusterConfiguration configuration;
    private final InfinispanRemoteManager manager;
    private final InfinispanClusterView.LocalMember localMember;
    private final LeadershipService leadership;
    private RemoteCache<String, String> cache;

    protected InfinispanRemoteClusterView(InfinispanRemoteClusterService cluster, InfinispanRemoteClusterConfiguration configuration, String namespace) {
        super((CamelClusterService)cluster, namespace);
        this.configuration = configuration;
        this.manager = new InfinispanRemoteManager((InfinispanRemoteConfiguration)this.configuration.getConfiguration());
        this.leadership = new LeadershipService();
        this.localMember = new InfinispanClusterView.LocalMember((InfinispanClusterView)this, cluster.getId());
    }

    public void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService((Service)this.manager);
        this.cache = (RemoteCache)this.manager.getCache(this.getNamespace(), RemoteCache.class);
        ServiceHelper.startService((Service)this.leadership);
    }

    public void doStop() throws Exception {
        super.doStop();
        LOGGER.info("shutdown service: {}", (Object)this.getClusterService().getId());
        ServiceHelper.stopService((Service)this.leadership);
        ServiceHelper.stopService((Service)this.manager);
        this.cache = null;
    }

    public CamelClusterMember getLocalMember() {
        return this.localMember;
    }

    public List<CamelClusterMember> getMembers() {
        return this.cache != null ? this.cache.keySet().stream().filter(Predicates.negate("__camel_leader"::equals)).map(x$0 -> new InfinispanClusterView.ClusterMember((InfinispanClusterView)this, x$0)).collect(Collectors.toList()) : Collections.emptyList();
    }

    public Optional<CamelClusterMember> getLeader() {
        if (this.cache == null) {
            return Optional.empty();
        }
        String id = (String)this.cache.get((Object)"__camel_leader");
        if (id == null) {
            return Optional.empty();
        }
        return Optional.of(new InfinispanClusterView.ClusterMember((InfinispanClusterView)this, id));
    }

    protected boolean isLeader(String id) {
        if (this.cache == null) {
            return false;
        }
        if (id == null) {
            return false;
        }
        String key = "__camel_leader";
        String val = (String)this.cache.get((Object)"__camel_leader");
        return Objects.equals(id, val);
    }

    @ClientListener
    private final class LeadershipService
    extends ServiceSupport {
        private final int lifespan;
        private final AtomicBoolean running;
        private ScheduledExecutorService executorService;
        private Long version;

        LeadershipService() {
            this.lifespan = (int)InfinispanRemoteClusterView.this.configuration.getLifespanTimeUnit().toSeconds(InfinispanRemoteClusterView.this.configuration.getLifespan());
            this.running = new AtomicBoolean(false);
        }

        protected void doStart() throws Exception {
            super.doStart();
            this.running.set(true);
            this.executorService = InfinispanUtil.newSingleThreadScheduledExecutor((CamelContext)InfinispanRemoteClusterView.this.getCamelContext(), (Object)((Object)this), (String)InfinispanRemoteClusterView.this.getLocalMember().getId());
            InfinispanRemoteClusterView.this.cache.put((Object)InfinispanRemoteClusterView.this.getLocalMember().getId(), (Object)"false", InfinispanRemoteClusterView.this.configuration.getLifespan(), InfinispanRemoteClusterView.this.configuration.getLifespanTimeUnit());
            InfinispanRemoteClusterView.this.cache.addClientListener((Object)this);
            this.executorService.scheduleAtFixedRate(this::run, 0L, InfinispanRemoteClusterView.this.configuration.getLifespan() / 2L, InfinispanRemoteClusterView.this.configuration.getLifespanTimeUnit());
        }

        protected void doStop() throws Exception {
            super.doStop();
            this.running.set(false);
            if (InfinispanRemoteClusterView.this.cache != null) {
                InfinispanRemoteClusterView.this.cache.removeClientListener((Object)this);
            }
            InfinispanRemoteClusterView.this.getCamelContext().getExecutorServiceManager().shutdownGraceful((ExecutorService)this.executorService);
            if (InfinispanRemoteClusterView.this.cache != null) {
                if (this.version != null) {
                    InfinispanRemoteClusterView.this.cache.removeWithVersion((Object)"__camel_leader", this.version.longValue());
                }
                LOGGER.info("Removing local member, key={}", (Object)InfinispanRemoteClusterView.this.getLocalMember().getId());
                InfinispanRemoteClusterView.this.cache.remove((Object)InfinispanRemoteClusterView.this.getLocalMember().getId());
            }
            this.version = null;
        }

        private boolean isLeader() {
            return InfinispanRemoteClusterView.this.getLocalMember().isLeader();
        }

        private void setLeader(boolean leader) {
            ((InfinispanClusterView.LocalMember)InfinispanRemoteClusterView.this.getLocalMember()).setLeader(leader);
        }

        private synchronized void run() {
            if (!this.running.get()) {
                return;
            }
            String leaderKey = "__camel_leader";
            String localId = InfinispanRemoteClusterView.this.getLocalMember().getId();
            if (this.isLeader() && this.version != null) {
                LOGGER.debug("Lock refresh key={}, id{} with version={}", new Object[]{"__camel_leader", localId, this.version});
                if (!InfinispanRemoteClusterView.this.cache.replaceWithVersion((Object)"__camel_leader", (Object)InfinispanRemoteClusterView.this.getClusterService().getId(), this.version.longValue(), this.lifespan)) {
                    LOGGER.debug("Failed to refresh the lock key={}, id={}, version={}", new Object[]{"__camel_leader", localId, this.version});
                    this.setLeader(false);
                } else {
                    this.version = InfinispanRemoteClusterView.this.cache.getWithMetadata((Object)"__camel_leader").getVersion();
                    LOGGER.debug("Lock refreshed key={}, ud={}, with new version={}", new Object[]{"__camel_leader", localId, this.version});
                }
            }
            if (!this.isLeader()) {
                LOGGER.debug("Try to acquire lock key={}, id={}", (Object)"__camel_leader", (Object)localId);
                Object result = InfinispanRemoteClusterView.this.cache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).putIfAbsent((Object)"__camel_leader", (Object)localId, InfinispanRemoteClusterView.this.configuration.getLifespan(), InfinispanRemoteClusterView.this.configuration.getLifespanTimeUnit());
                if (result == null) {
                    this.setLeader(true);
                    this.version = InfinispanRemoteClusterView.this.cache.getWithMetadata((Object)"__camel_leader").getVersion();
                    LOGGER.debug("Lock acquired key={}, id={}, with version={}", new Object[]{"__camel_leader", localId, this.version});
                } else if (Objects.equals(InfinispanRemoteClusterView.this.getClusterService().getId(), result) && !this.isLeader()) {
                    this.setLeader(true);
                    this.version = InfinispanRemoteClusterView.this.cache.getWithMetadata((Object)"__camel_leader").getVersion();
                    LOGGER.debug("Lock resumed key={}, id={} with version={}", new Object[]{"__camel_leader", localId, this.version});
                } else {
                    LOGGER.debug("Failed to acquire the lock key={}, id={}", (Object)"__camel_leader", (Object)localId);
                    this.setLeader(false);
                }
            }
            InfinispanRemoteClusterView.this.cache.put((Object)InfinispanRemoteClusterView.this.getLocalMember().getId(), (Object)(this.isLeader() ? "true" : "false"), InfinispanRemoteClusterView.this.configuration.getLifespan(), InfinispanRemoteClusterView.this.configuration.getLifespanTimeUnit());
        }

        @ClientCacheEntryRemoved
        public void onCacheEntryRemoved(ClientCacheEntryRemovedEvent<String> event) {
            if (!this.running.get()) {
                return;
            }
            LOGGER.debug("onCacheEntryRemoved id={}, lock-key={}, event-key={}", new Object[]{InfinispanRemoteClusterView.this.getLocalMember().getId(), "__camel_leader", event.getKey()});
            if (Objects.equals("__camel_leader", event.getKey())) {
                this.executorService.execute(this::run);
            }
        }

        @ClientCacheEntryExpired
        public void onCacheEntryExpired(ClientCacheEntryExpiredEvent<String> event) {
            if (!this.running.get()) {
                return;
            }
            LOGGER.debug("onCacheEntryExpired id={}, lock-key={}, event-key={}", new Object[]{InfinispanRemoteClusterView.this.getLocalMember().getId(), "__camel_leader", event.getKey()});
            if (Objects.equals("__camel_leader", event.getKey())) {
                this.executorService.execute(this::run);
            }
        }
    }
}

