/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.functions;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.google.functions.GoogleCloudFunctionsConfiguration;
import org.apache.camel.component.google.functions.GoogleCloudFunctionsEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="google-functions")
public class GoogleCloudFunctionsComponent
extends DefaultComponent {
    @Metadata
    private GoogleCloudFunctionsConfiguration configuration = new GoogleCloudFunctionsConfiguration();

    public GoogleCloudFunctionsComponent() {
    }

    public GoogleCloudFunctionsComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.isBlank()) {
            throw new IllegalArgumentException("Function name must be specified.");
        }
        GoogleCloudFunctionsConfiguration configurationCopy = this.configuration != null ? this.configuration.copy() : new GoogleCloudFunctionsConfiguration();
        configurationCopy.setFunctionName(remaining);
        GoogleCloudFunctionsEndpoint endpoint = new GoogleCloudFunctionsEndpoint(uri, this, configurationCopy);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public GoogleCloudFunctionsConfiguration getConfiguration() {
        return this.configuration;
    }
}

