/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.bigquery.sql;

import com.google.cloud.RetryOption;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.Job;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobException;
import com.google.cloud.bigquery.JobId;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.JobStatistics;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.bigquery.QueryParameterValue;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.TableResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.google.bigquery.sql.GoogleBigQuerySQLConfiguration;
import org.apache.camel.component.google.bigquery.sql.GoogleBigQuerySQLEndpoint;
import org.apache.camel.component.google.bigquery.sql.SqlHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleBigQuerySQLProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleBigQuerySQLProducer.class);
    private final GoogleBigQuerySQLConfiguration configuration;
    private BigQuery bigquery;
    private String query;
    private Set<String> queryParameterNames;

    public GoogleBigQuerySQLProducer(BigQuery bigquery, GoogleBigQuerySQLEndpoint endpoint, GoogleBigQuerySQLConfiguration configuration) {
        super((Endpoint)endpoint);
        this.bigquery = bigquery;
        this.configuration = configuration;
    }

    public void process(Exchange exchange) throws Exception {
        Object queryResult;
        String translatedQuery = SqlHelper.translateQuery(this.query, exchange);
        Map<String, Object> queryParameters = this.extractParameters(exchange);
        Message message = exchange.getMessage();
        message.setHeader("CamelGoogleBigQueryTranslatedQuery", (Object)translatedQuery);
        JobId jobId = (JobId)message.getHeader("CamelGoogleBigQueryJobId", JobId.class);
        String pageToken = (String)message.getHeader("CamelGoogleBigQueryPageToken", String.class);
        if (pageToken == null && this.configuration.getPageToken() != null) {
            pageToken = this.configuration.getPageToken();
        }
        if ((queryResult = this.executeSQL(jobId, translatedQuery, queryParameters, pageToken)) instanceof Long) {
            LOG.debug("The query {} affected {} rows", (Object)this.query, queryResult);
            message.setBody(queryResult);
        } else if (queryResult instanceof TableResult) {
            TableResult result = (TableResult)queryResult;
            Schema schema = result.getSchema();
            if (schema != null) {
                List<Map<String, Object>> rows = this.processSelectResult(result, schema);
                LOG.debug("The query {} returned {} rows", (Object)this.query, (Object)rows.size());
                message.setBody(rows);
                message.setHeader("CamelGoogleBigQueryNextPageToken", (Object)result.getNextPageToken());
            } else {
                LOG.debug("Query result schema is null. Unable to process the result set.");
                message.setBody((Object)result.getTotalRows());
            }
        }
    }

    private Object executeSQL(JobId jobId, String translatedQuery, Map<String, Object> queryParameters, String pageToken) throws Exception {
        QueryJobConfiguration.Builder builder = QueryJobConfiguration.newBuilder((String)translatedQuery).setUseLegacySql(Boolean.valueOf(false));
        this.setQueryParameters(queryParameters, builder);
        QueryJobConfiguration queryJobConfiguration = builder.build();
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Sending query to bigquery standard sql: {}", (Object)translatedQuery);
            }
            JobId queryJobId = ObjectHelper.isNotEmpty((Object)jobId) ? jobId : JobId.of((String)this.configuration.getProjectId(), (String)UUID.randomUUID().toString());
            Job job = this.bigquery.create(JobInfo.of((JobId)queryJobId, (JobConfiguration)queryJobConfiguration), new BigQuery.JobOption[0]).waitFor(new RetryOption[0]);
            JobStatistics.QueryStatistics statistics = (JobStatistics.QueryStatistics)job.getStatistics();
            TableResult result = pageToken != null ? job.getQueryResults(new BigQuery.QueryResultsOption[]{BigQuery.QueryResultsOption.pageToken((String)pageToken)}) : job.getQueryResults(new BigQuery.QueryResultsOption[0]);
            Long numAffectedRows = statistics.getNumDmlAffectedRows();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Query {} - Affected rows {} - Result {}", new Object[]{translatedQuery, numAffectedRows, result});
            }
            if (numAffectedRows != null) {
                return numAffectedRows;
            }
            return result;
        }
        catch (JobException e) {
            throw new Exception("Query " + translatedQuery + " failed: " + String.valueOf(e.getErrors()), e);
        }
        catch (BigQueryException e) {
            throw new Exception("Query " + translatedQuery + " failed: " + String.valueOf(e.getError()), e);
        }
    }

    private Map<String, Object> extractParameters(Exchange exchange) {
        if (this.queryParameterNames == null || this.queryParameterNames.isEmpty()) {
            return null;
        }
        Message message = exchange.getMessage();
        HashMap headers = new HashMap(message.getHeaders());
        if (message.getBody() instanceof Map) {
            try {
                headers.putAll((Map)message.getBody(Map.class));
            }
            catch (ClassCastException e) {
                LOG.warn("Unable to perform cast while extracting header parameters: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>(this.queryParameterNames.size());
        this.queryParameterNames.forEach(s -> {
            Object value = headers.get(s);
            if (value == null) {
                throw new RuntimeExchangeException("SQL parameter with name '" + s + "' not found in the message headers", exchange);
            }
            result.put((String)s, headers.get(s));
        });
        return result;
    }

    private void setQueryParameters(Map<String, Object> params, QueryJobConfiguration.Builder builder) {
        if (params == null) {
            return;
        }
        params.forEach((key, value) -> {
            QueryParameterValue parameterValue;
            try {
                parameterValue = QueryParameterValue.of((Object)value, value.getClass());
            }
            catch (IllegalArgumentException e) {
                LOG.warn("{} Fallback to *.toString() value.", (Object)e.getMessage());
                parameterValue = QueryParameterValue.of((Object)value.toString(), (StandardSQLTypeName)StandardSQLTypeName.STRING);
            }
            builder.addNamedParameter(key, parameterValue);
        });
    }

    private List<Map<String, Object>> processSelectResult(TableResult result, Schema schema) {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        for (FieldValueList row : result.getValues()) {
            HashMap<String, Object> rowMap = new HashMap<String, Object>();
            for (Field field : schema.getFields()) {
                rowMap.put(field.getName(), row.get(field.getName()).getValue());
            }
            rows.add(rowMap);
        }
        return rows;
    }

    public GoogleBigQuerySQLEndpoint getEndpoint() {
        return (GoogleBigQuerySQLEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        String placeholder = ":#";
        this.query = SqlHelper.resolveQuery(this.getEndpoint().getCamelContext(), this.configuration.getQueryString(), placeholder);
        this.queryParameterNames = SqlHelper.extractParameterNames(this.query);
    }
}

