/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.git.consumer;

import java.util.Queue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Processor;
import org.apache.camel.component.git.GitEndpoint;
import org.apache.camel.component.git.RepositoryFactory;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGitConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGitConsumer.class);
    private final GitEndpoint endpoint;
    private Repository repo;
    private Git git;

    protected AbstractGitConsumer(GitEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.repo = this.getLocalRepository();
        this.git = new Git(this.repo);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.repo.close();
        this.git.close();
    }

    private Repository getLocalRepository() {
        return RepositoryFactory.of(this.endpoint);
    }

    public Repository getRepository() {
        return this.repo;
    }

    protected Git getGit() {
        return this.git;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total;
        int answer = total = exchanges.size();
        if (this.maxMessagesPerPoll > 0 && total > this.maxMessagesPerPoll) {
            LOG.debug("Limiting to maximum messages to poll {} as there were {} messages in this poll.", (Object)this.maxMessagesPerPoll, (Object)total);
            total = this.maxMessagesPerPoll;
        }
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)exchanges.poll();
            exchange.setProperty(ExchangePropertyKey.BATCH_INDEX, (Object)index);
            exchange.setProperty(ExchangePropertyKey.BATCH_SIZE, (Object)total);
            exchange.setProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            Object value = this.onPreProcessed(exchange);
            this.getProcessor().process(exchange);
            this.onProcessed(exchange, value);
        }
        return answer;
    }

    public abstract Object onPreProcessed(Exchange var1);

    public abstract void onProcessed(Exchange var1, Object var2);
}

