/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flatpack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.flatpack.DataSet;
import org.apache.camel.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Converter
public final class FlatpackConverter {
    private FlatpackConverter() {
    }

    @Converter
    public static Map toMap(DataSet dataSet) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        FlatpackConverter.putValues(map, dataSet);
        return map;
    }

    @Converter
    public static List toList(DataSet dataSet) {
        ArrayList<HashMap<String, Object>> answer = new ArrayList<HashMap<String, Object>>();
        dataSet.goTop();
        while (dataSet.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            FlatpackConverter.putValues(map, dataSet);
            answer.add(map);
        }
        return answer;
    }

    private static void putValues(Map<String, Object> map, DataSet dataSet) {
        boolean header = dataSet.isRecordID("header");
        boolean trailer = dataSet.isRecordID("trailer");
        String[] columns = header ? dataSet.getColumns("header") : (trailer ? dataSet.getColumns("trailer") : dataSet.getColumns());
        for (String column : columns) {
            String value = dataSet.getString(column);
            map.put(column, value);
        }
    }
}

