/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericFileProcessStrategySupport<T>
extends ServiceSupport
implements GenericFileProcessStrategy<T>,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(GenericFileProcessStrategySupport.class);
    protected GenericFileExclusiveReadLockStrategy<T> exclusiveReadLockStrategy;
    protected CamelContext camelContext;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void prepareOnStartup(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint) throws Exception {
        if (this.exclusiveReadLockStrategy != null) {
            this.exclusiveReadLockStrategy.prepareOnStartup(operations, endpoint);
        }
    }

    @Override
    public boolean begin(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, Exchange exchange, GenericFile<T> file) throws Exception {
        boolean lock;
        return this.exclusiveReadLockStrategy == null || (lock = this.exclusiveReadLockStrategy.acquireExclusiveReadLock(operations, file, exchange));
    }

    @Override
    public void abort(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, Exchange exchange, GenericFile<T> file) throws Exception {
        this.deleteLocalWorkFile(exchange);
        operations.releaseRetrievedFileResources(exchange);
        if (this.exclusiveReadLockStrategy != null) {
            this.exclusiveReadLockStrategy.releaseExclusiveReadLockOnAbort(operations, file, exchange);
        }
    }

    @Override
    public void commit(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, Exchange exchange, GenericFile<T> file) throws Exception {
        this.deleteLocalWorkFile(exchange);
        operations.releaseRetrievedFileResources(exchange);
        if (this.exclusiveReadLockStrategy != null) {
            this.exclusiveReadLockStrategy.releaseExclusiveReadLockOnCommit(operations, file, exchange);
        }
    }

    @Override
    public void rollback(GenericFileOperations<T> operations, GenericFileEndpoint<T> endpoint, Exchange exchange, GenericFile<T> file) throws Exception {
        this.deleteLocalWorkFile(exchange);
        operations.releaseRetrievedFileResources(exchange);
        if (this.exclusiveReadLockStrategy != null) {
            this.exclusiveReadLockStrategy.releaseExclusiveReadLockOnRollback(operations, file, exchange);
        }
    }

    public GenericFileExclusiveReadLockStrategy<T> getExclusiveReadLockStrategy() {
        return this.exclusiveReadLockStrategy;
    }

    public void setExclusiveReadLockStrategy(GenericFileExclusiveReadLockStrategy<T> exclusiveReadLockStrategy) {
        this.exclusiveReadLockStrategy = exclusiveReadLockStrategy;
    }

    protected GenericFile<T> renameFile(GenericFileOperations<T> operations, GenericFile<T> from, GenericFile<T> to) {
        try {
            operations.deleteFile(to.getAbsoluteFilePath());
        }
        catch (GenericFileOperationFailedException genericFileOperationFailedException) {
            // empty catch block
        }
        boolean mkdir = operations.buildDirectory(to.getParent(), to.isAbsolute());
        if (!mkdir) {
            throw new GenericFileOperationFailedException("Cannot create directory: " + to.getParent() + " (could be because of denied permissions)");
        }
        LOG.debug("Renaming file: {} to: {}", from, to);
        boolean renamed = operations.renameFile(from.getAbsoluteFilePath(), to.getAbsoluteFilePath());
        if (!renamed) {
            throw new GenericFileOperationFailedException("Cannot rename file: " + from + " to: " + to);
        }
        return to;
    }

    protected void deleteLocalWorkFile(Exchange exchange) {
        File f;
        String local = (String)exchange.getIn().getHeader("CamelFileLocalWorkPath", String.class);
        if (local != null && (f = new File(local)).exists()) {
            boolean deleted = FileUtil.deleteFile((File)f);
            LOG.trace("Local work file: {} was deleted: {}", (Object)local, (Object)deleted);
        }
    }

    protected void doStart() throws Exception {
        GenericFileExclusiveReadLockStrategy<T> genericFileExclusiveReadLockStrategy = this.exclusiveReadLockStrategy;
        if (genericFileExclusiveReadLockStrategy instanceof CamelContextAware) {
            CamelContextAware camelContextAware = (CamelContextAware)genericFileExclusiveReadLockStrategy;
            camelContextAware.setCamelContext(this.camelContext);
        }
        ServiceHelper.startService(this.exclusiveReadLockStrategy);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.exclusiveReadLockStrategy);
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.exclusiveReadLockStrategy);
    }
}

