/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.csv;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVStrategy;
import org.apache.commons.csv.writer.CSVConfig;
import org.apache.commons.csv.writer.CSVField;
import org.apache.commons.csv.writer.CSVWriter;

public class CsvDataFormat
implements DataFormat {
    private CSVStrategy strategy = CSVStrategy.DEFAULT_STRATEGY;
    private CSVConfig config = new CSVConfig();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object object, OutputStream outputStream) throws Exception {
        Map map = (Map)ExchangeHelper.convertToMandatoryType((Exchange)exchange, Map.class, (Object)object);
        OutputStreamWriter out = new OutputStreamWriter(outputStream);
        try {
            CSVConfig conf = this.getConfig();
            Set set = map.keySet();
            for (Object value : set) {
                if (value == null) continue;
                String text = value.toString();
                CSVField field = new CSVField(text);
                conf.addField(field);
            }
            CSVWriter writer = new CSVWriter(conf);
            writer.setWriter((Writer)out);
            writer.writeRecord(map);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        InputStreamReader in = new InputStreamReader(inputStream);
        try {
            ArrayList<List<String>> arrayList;
            String[] strings;
            CSVParser parser = new CSVParser((Reader)in, this.getStrategy());
            ArrayList<List<String>> list = new ArrayList<List<String>>();
            while ((strings = parser.getLine()) != null) {
                List<String> line = Arrays.asList(strings);
                list.add(line);
            }
            if (list.size() == 1) {
                arrayList = list.get(0);
                return arrayList;
            }
            arrayList = list;
            return arrayList;
        }
        finally {
            in.close();
        }
    }

    public CSVConfig getConfig() {
        if (this.config == null) {
            this.config = this.createConfig();
        }
        return this.config;
    }

    public void setConfig(CSVConfig config) {
        this.config = config;
    }

    public CSVStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(CSVStrategy strategy) {
        this.strategy = strategy;
    }

    protected CSVConfig createConfig() {
        return new CSVConfig();
    }
}

