/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.cms.sig;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.crypto.cms.common.DefaultCryptoCmsUnMarshallerConfiguration;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsException;
import org.apache.camel.component.crypto.cms.sig.SignedDataVerifierConfiguration;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class DefaultSignedDataVerifierConfiguration
extends DefaultCryptoCmsUnMarshallerConfiguration
implements SignedDataVerifierConfiguration,
Cloneable {
    @UriParam(label="verify", defaultValue="false")
    private Boolean signedDataHeaderBase64 = Boolean.FALSE;
    @UriParam(label="verify", defaultValue="true")
    private Boolean verifySignaturesOfAllSigners = Boolean.TRUE;

    public void setSignedDataHeaderBase64(Boolean signedDataHeaderBase64) {
        this.signedDataHeaderBase64 = signedDataHeaderBase64;
    }

    @Override
    public Boolean isSignedDataHeaderBase64(Exchange exchange) throws CryptoCmsException {
        return this.signedDataHeaderBase64;
    }

    public void setVerifySignaturesOfAllSigners(Boolean verifySignaturesOfAllSigners) {
        this.verifySignaturesOfAllSigners = verifySignaturesOfAllSigners;
    }

    @Override
    public Boolean isVerifySignaturesOfAllSigners(Exchange exchange) throws CryptoCmsException {
        return this.verifySignaturesOfAllSigners;
    }

    @Override
    public Collection<X509Certificate> getCertificates(Exchange exchange) throws CryptoCmsException {
        KeyStore keystore = this.getKeyStore();
        try {
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(keystore.size());
            Enumeration<String> aliases = keystore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate cert = keystore.getCertificate(alias);
                if (!(cert instanceof X509Certificate)) continue;
                certs.add((X509Certificate)cert);
            }
            return certs;
        }
        catch (KeyStoreException e) {
            throw new CryptoCmsException("Problem during reading the certificates of the verifier keystore");
        }
    }

    @Override
    public DefaultSignedDataVerifierConfiguration copy() {
        try {
            return (DefaultSignedDataVerifierConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

