/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.cms.sig;

import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.apache.camel.Exchange;
import org.apache.camel.component.crypto.cms.common.DefaultCryptoCmsConfiguration;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsException;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsNoKeyOrCertificateForAliasException;
import org.apache.camel.component.crypto.cms.sig.SignerInfo;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;

@UriParams
public class DefaultSignerInfo
extends DefaultCryptoCmsConfiguration
implements SignerInfo {
    @UriParam(label="sign")
    private String privateKeyAlias;
    @UriParam(label="sign")
    private char[] password;
    @UriParam(label="sign", defaultValue="SHA256withRSA")
    private String signatureAlgorithm = "SHA256withRSA";
    @UriParam(label="sign", defaultValue="true")
    private boolean includeCertificates = true;
    @UriParam(label="sign")
    private CMSAttributeTableGenerator signedAttributeGenerator = new DefaultSignedAttributeTableGenerator();
    @UriParam(label="sign", defaultValue="null")
    private CMSAttributeTableGenerator unsignedAttributeGenerator;

    public void setPassword(char[] password) {
        this.password = password;
    }

    protected char[] getPassword(Exchange exchange) throws CryptoCmsException {
        if (this.password != null) {
            return this.password;
        }
        String pw = null;
        if (this.getKeyStoreParameters() != null) {
            pw = this.getKeyStoreParameters().getPassword();
        }
        if (pw == null) {
            throw new CryptoCmsException("No password for accessing the private key from the keystore found for the singer infor " + this);
        }
        return pw.toCharArray();
    }

    protected String getPrivateKeyAlias(Exchange exchange) throws CryptoCmsException {
        if (this.privateKeyAlias == null) {
            throw new CryptoCmsException("No alias defined for signer info " + this);
        }
        return this.privateKeyAlias;
    }

    public void setPrivateKeyAlias(String privateKeyAlias) {
        this.privateKeyAlias = privateKeyAlias;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public void setIncludeCertificates(boolean includeCertificates) {
        this.includeCertificates = includeCertificates;
    }

    @Override
    public String getSignatureAlgorithm(Exchange exchange) throws CryptoCmsException {
        return this.signatureAlgorithm;
    }

    @Override
    public PrivateKey getPrivateKey(Exchange exchange) throws CryptoCmsException {
        String alias = this.getPrivateKeyAlias(exchange);
        try {
            Key key = this.getKeyStore().getKey(alias, this.getPassword(exchange));
            if (key instanceof PrivateKey) {
                return (PrivateKey)key;
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new CryptoCmsException("Problem occured during accessing the private key for the alias '" + alias + "' in the keystore of signer " + this);
        }
        throw new CryptoCmsNoKeyOrCertificateForAliasException("No private key found  for the alias '" + alias + "' in the keystore of signer " + this);
    }

    @Override
    public X509Certificate getCertificate(Exchange exchange) throws CryptoCmsException {
        Certificate cert;
        String alias = this.getPrivateKeyAlias(exchange);
        try {
            cert = this.getKeyStore().getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new CryptoCmsException("Problem during accessing the certificate for the alias '" + alias + "' in the signer " + this, e);
        }
        if (cert instanceof X509Certificate) {
            return (X509Certificate)cert;
        }
        throw new CryptoCmsNoKeyOrCertificateForAliasException("No X.509 certificate found for alias '" + alias + "' in the keystore of signer " + this);
    }

    @Override
    public Certificate[] getCertificateChain(Exchange exchange) throws CryptoCmsException {
        if (this.includeCertificates) {
            Certificate[] certs;
            String alias = this.getPrivateKeyAlias(exchange);
            try {
                certs = this.getKeyStore().getCertificateChain(alias);
            }
            catch (KeyStoreException e) {
                throw new CryptoCmsException("Problem during accessing the certificate chain for the alias '" + alias + "' in the keystore of signer " + this, e);
            }
            if (certs == null) {
                return new Certificate[0];
            }
            return certs;
        }
        return new Certificate[0];
    }

    public void setSignedAttributeGenerator(CMSAttributeTableGenerator signedAttributeGenerator) {
        this.signedAttributeGenerator = signedAttributeGenerator;
    }

    public void setUnsignedAttributeGenerator(CMSAttributeTableGenerator unsignedAttributeGenerator) {
        this.unsignedAttributeGenerator = unsignedAttributeGenerator;
    }

    @Override
    public CMSAttributeTableGenerator getSignedAttributeGenerator(Exchange exchange) throws CryptoCmsException {
        return this.signedAttributeGenerator;
    }

    @Override
    public CMSAttributeTableGenerator getUnsignedAttributeGenerator(Exchange exchange) throws CryptoCmsException {
        return this.unsignedAttributeGenerator;
    }

    public String toString() {
        return "private key alias=" + this.privateKeyAlias + ", signature algorithm=" + this.signatureAlgorithm + ", isIncludeCertificates=" + this.includeCertificates;
    }
}

