/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Map;
import java.util.Properties;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.LocationHelper;
import org.apache.camel.util.OrderedLocationProperties;
import org.apache.camel.util.SensitiveUtils;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="properties", description="Displays the properties loaded by Camel")
public class PropertiesDevConsole
extends AbstractDevConsole {
    public PropertiesDevConsole() {
        super("camel", "properties", "Properties", "Displays the properties loaded by Camel");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        PropertiesComponent pc = this.getCamelContext().getPropertiesComponent();
        String loc = String.join((CharSequence)", ", pc.getLocations());
        sb.append(String.format("Properties loaded from locations: %s", loc));
        sb.append("\n");
        Properties p = pc.loadProperties();
        OrderedLocationProperties olp = null;
        if (p instanceof OrderedLocationProperties) {
            olp = (OrderedLocationProperties)p;
        }
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String k = entry.getKey().toString();
            Object v = entry.getValue();
            String string = loc = olp != null ? LocationHelper.locationSummary((OrderedLocationProperties)olp, (String)k) : null;
            if (SensitiveUtils.containsSensitive((String)k)) {
                sb.append(String.format("    %s %s = xxxxxx%n", loc, k));
                continue;
            }
            sb.append(String.format("    %s %s = %s%n", loc, k, v));
        }
        sb.append("\n");
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        PropertiesComponent pc = this.getCamelContext().getPropertiesComponent();
        root.put((Object)"locations", (Object)pc.getLocations());
        JsonArray arr = new JsonArray();
        Properties p = pc.loadProperties();
        OrderedLocationProperties olp = null;
        if (p instanceof OrderedLocationProperties) {
            olp = (OrderedLocationProperties)p;
        }
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String k = entry.getKey().toString();
            Object v = entry.getValue();
            String loc = olp != null ? olp.getLocation((Object)k) : null;
            JsonObject jo = new JsonObject();
            jo.put((Object)"key", (Object)k);
            jo.put((Object)"value", v);
            if (loc != null) {
                jo.put((Object)"location", (Object)loc);
                jo.put((Object)"internal", (Object)PropertiesDevConsole.isInternal(loc));
            }
            arr.add((Object)jo);
        }
        if (!arr.isEmpty()) {
            root.put((Object)"properties", (Object)arr);
        }
        return root;
    }

    private static boolean isInternal(String loc) {
        if (loc == null) {
            return false;
        }
        return "initial".equals(loc) || "override".equals(loc);
    }
}

