/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="system-properties", description="Displays Java System Properties")
@Configurer(extended=true)
public class SystemPropertiesDevConsole
extends AbstractDevConsole {
    public SystemPropertiesDevConsole() {
        super("jvm", "system-properties", "Java System Properties", "Displays Java System Properties");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        Properties p = System.getProperties();
        TreeSet<String> keys = new TreeSet<String>(p.stringPropertyNames());
        sb.append("System Properties:");
        sb.append("\n");
        for (String k : keys) {
            sb.append(String.format("    %s = %s\n", k, System.getProperty(k)));
        }
        sb.append("\n");
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        JsonArray arr = new JsonArray();
        root.put((Object)"systemProperties", (Object)arr);
        Properties p = System.getProperties();
        TreeSet<String> keys = new TreeSet<String>(p.stringPropertyNames());
        for (String k : keys) {
            JsonObject jo = new JsonObject();
            jo.put((Object)k, (Object)System.getProperty(k));
            arr.add((Object)jo);
        }
        return root;
    }
}

