/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import javax.sql.DataSource;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.sql.RowMapperFactory;
import org.apache.camel.component.sql.SqlComponent;

public interface SqlComponentBuilderFactory {
    public static SqlComponentBuilder sql() {
        return new SqlComponentBuilderImpl();
    }

    public static class SqlComponentBuilderImpl
    extends AbstractComponentBuilder<SqlComponent>
    implements SqlComponentBuilder {
        @Override
        protected SqlComponent buildConcreteComponent() {
            return new SqlComponent();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "dataSource": {
                    ((SqlComponent)component).setDataSource((DataSource)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((SqlComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((SqlComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((SqlComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "rowMapperFactory": {
                    ((SqlComponent)component).setRowMapperFactory((RowMapperFactory)value);
                    return true;
                }
                case "serviceLocationEnabled": {
                    ((SqlComponent)component).setServiceLocationEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "usePlaceholder": {
                    ((SqlComponent)component).setUsePlaceholder(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((SqlComponent)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((SqlComponent)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface SqlComponentBuilder
    extends ComponentBuilder<SqlComponent> {
        default public SqlComponentBuilder dataSource(DataSource dataSource) {
            this.doSetProperty("dataSource", dataSource);
            return this;
        }

        default public SqlComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public SqlComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public SqlComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public SqlComponentBuilder rowMapperFactory(RowMapperFactory rowMapperFactory) {
            this.doSetProperty("rowMapperFactory", rowMapperFactory);
            return this;
        }

        default public SqlComponentBuilder serviceLocationEnabled(boolean serviceLocationEnabled) {
            this.doSetProperty("serviceLocationEnabled", serviceLocationEnabled);
            return this;
        }

        default public SqlComponentBuilder usePlaceholder(boolean usePlaceholder) {
            this.doSetProperty("usePlaceholder", usePlaceholder);
            return this;
        }

        default public SqlComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public SqlComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }
    }
}

