/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.msk.MSK2Component;
import org.apache.camel.component.aws2.msk.MSK2Configuration;
import org.apache.camel.component.aws2.msk.MSK2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.kafka.KafkaClient;

public interface Aws2MskComponentBuilderFactory {
    public static Aws2MskComponentBuilder aws2Msk() {
        return new Aws2MskComponentBuilderImpl();
    }

    public static class Aws2MskComponentBuilderImpl
    extends AbstractComponentBuilder<MSK2Component>
    implements Aws2MskComponentBuilder {
        @Override
        protected MSK2Component buildConcreteComponent() {
            return new MSK2Component();
        }

        private MSK2Configuration getOrCreateConfiguration(MSK2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new MSK2Configuration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((MSK2Component)component).setConfiguration((MSK2Configuration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((MSK2Component)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((MSK2Component)component).setOperation((MSK2Operations)value);
                    return true;
                }
                case "overrideEndpoint": {
                    this.getOrCreateConfiguration((MSK2Component)component).setOverrideEndpoint(((Boolean)value).booleanValue());
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((MSK2Component)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((MSK2Component)component).setRegion((String)value);
                    return true;
                }
                case "uriEndpointOverride": {
                    this.getOrCreateConfiguration((MSK2Component)component).setUriEndpointOverride((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((MSK2Component)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "mskClient": {
                    this.getOrCreateConfiguration((MSK2Component)component).setMskClient((KafkaClient)value);
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((MSK2Component)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((MSK2Component)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((MSK2Component)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((MSK2Component)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((MSK2Component)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((MSK2Component)component).setAccessKey((String)value);
                    return true;
                }
                case "profileCredentialsName": {
                    this.getOrCreateConfiguration((MSK2Component)component).setProfileCredentialsName((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((MSK2Component)component).setSecretKey((String)value);
                    return true;
                }
                case "sessionToken": {
                    this.getOrCreateConfiguration((MSK2Component)component).setSessionToken((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((MSK2Component)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "useDefaultCredentialsProvider": {
                    this.getOrCreateConfiguration((MSK2Component)component).setUseDefaultCredentialsProvider(Boolean.valueOf((Boolean)value));
                    return true;
                }
                case "useProfileCredentialsProvider": {
                    this.getOrCreateConfiguration((MSK2Component)component).setUseProfileCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
                case "useSessionCredentials": {
                    this.getOrCreateConfiguration((MSK2Component)component).setUseSessionCredentials(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2MskComponentBuilder
    extends ComponentBuilder<MSK2Component> {
        default public Aws2MskComponentBuilder configuration(MSK2Configuration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2MskComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2MskComponentBuilder operation(MSK2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2MskComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Aws2MskComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Aws2MskComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2MskComponentBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public Aws2MskComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Aws2MskComponentBuilder mskClient(KafkaClient mskClient) {
            this.doSetProperty("mskClient", mskClient);
            return this;
        }

        default public Aws2MskComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public Aws2MskComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }

        default public Aws2MskComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2MskComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2MskComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2MskComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2MskComponentBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public Aws2MskComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public Aws2MskComponentBuilder sessionToken(String sessionToken) {
            this.doSetProperty("sessionToken", sessionToken);
            return this;
        }

        default public Aws2MskComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2MskComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public Aws2MskComponentBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public Aws2MskComponentBuilder useSessionCredentials(boolean useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }
}

