/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.pinecone.PineconeVectorDbAction;
import org.apache.camel.component.pinecone.PineconeVectorDbComponent;
import org.apache.camel.component.pinecone.PineconeVectorDbConfiguration;

public interface PineconeComponentBuilderFactory {
    public static PineconeComponentBuilder pinecone() {
        return new PineconeComponentBuilderImpl();
    }

    public static class PineconeComponentBuilderImpl
    extends AbstractComponentBuilder<PineconeVectorDbComponent>
    implements PineconeComponentBuilder {
        @Override
        protected PineconeVectorDbComponent buildConcreteComponent() {
            return new PineconeVectorDbComponent();
        }

        private PineconeVectorDbConfiguration getOrCreateConfiguration(PineconeVectorDbComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new PineconeVectorDbConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "action": {
                    this.getOrCreateConfiguration((PineconeVectorDbComponent)component).setAction((PineconeVectorDbAction)value);
                    return true;
                }
                case "cloud": {
                    this.getOrCreateConfiguration((PineconeVectorDbComponent)component).setCloud((String)value);
                    return true;
                }
                case "cloudRegion": {
                    this.getOrCreateConfiguration((PineconeVectorDbComponent)component).setCloudRegion((String)value);
                    return true;
                }
                case "collectionDimension": {
                    this.getOrCreateConfiguration((PineconeVectorDbComponent)component).setCollectionDimension((Integer)value);
                    return true;
                }
                case "collectionSimilarityMetric": {
                    this.getOrCreateConfiguration((PineconeVectorDbComponent)component).setCollectionSimilarityMetric((String)value);
                    return true;
                }
                case "configuration": {
                    ((PineconeVectorDbComponent)component).setConfiguration((PineconeVectorDbConfiguration)value);
                    return true;
                }
                case "host": {
                    this.getOrCreateConfiguration((PineconeVectorDbComponent)component).setHost((String)value);
                    return true;
                }
                case "indexName": {
                    this.getOrCreateConfiguration((PineconeVectorDbComponent)component).setIndexName((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((PineconeVectorDbComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((PineconeVectorDbComponent)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((PineconeVectorDbComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((PineconeVectorDbComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "tls": {
                    this.getOrCreateConfiguration((PineconeVectorDbComponent)component).setTls(((Boolean)value).booleanValue());
                    return true;
                }
                case "token": {
                    this.getOrCreateConfiguration((PineconeVectorDbComponent)component).setToken((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface PineconeComponentBuilder
    extends ComponentBuilder<PineconeVectorDbComponent> {
        default public PineconeComponentBuilder action(PineconeVectorDbAction action) {
            this.doSetProperty("action", action);
            return this;
        }

        default public PineconeComponentBuilder cloud(String cloud) {
            this.doSetProperty("cloud", cloud);
            return this;
        }

        default public PineconeComponentBuilder cloudRegion(String cloudRegion) {
            this.doSetProperty("cloudRegion", cloudRegion);
            return this;
        }

        default public PineconeComponentBuilder collectionDimension(Integer collectionDimension) {
            this.doSetProperty("collectionDimension", collectionDimension);
            return this;
        }

        default public PineconeComponentBuilder collectionSimilarityMetric(String collectionSimilarityMetric) {
            this.doSetProperty("collectionSimilarityMetric", collectionSimilarityMetric);
            return this;
        }

        default public PineconeComponentBuilder configuration(PineconeVectorDbConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public PineconeComponentBuilder host(String host) {
            this.doSetProperty("host", host);
            return this;
        }

        default public PineconeComponentBuilder indexName(String indexName) {
            this.doSetProperty("indexName", indexName);
            return this;
        }

        default public PineconeComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public PineconeComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public PineconeComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public PineconeComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public PineconeComponentBuilder tls(boolean tls) {
            this.doSetProperty("tls", tls);
            return this;
        }

        default public PineconeComponentBuilder token(String token) {
            this.doSetProperty("token", token);
            return this;
        }
    }
}

