/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.weaviate.WeaviateVectorDbComponent;
import org.apache.camel.component.weaviate.WeaviateVectorDbConfiguration;

public interface WeaviateComponentBuilderFactory {
    public static WeaviateComponentBuilder weaviate() {
        return new WeaviateComponentBuilderImpl();
    }

    public static class WeaviateComponentBuilderImpl
    extends AbstractComponentBuilder<WeaviateVectorDbComponent>
    implements WeaviateComponentBuilder {
        @Override
        protected WeaviateVectorDbComponent buildConcreteComponent() {
            return new WeaviateVectorDbComponent();
        }

        private WeaviateVectorDbConfiguration getOrCreateConfiguration(WeaviateVectorDbComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new WeaviateVectorDbConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "apiKey": {
                    this.getOrCreateConfiguration((WeaviateVectorDbComponent)component).setApiKey((String)value);
                    return true;
                }
                case "configuration": {
                    ((WeaviateVectorDbComponent)component).setConfiguration((WeaviateVectorDbConfiguration)value);
                    return true;
                }
                case "host": {
                    this.getOrCreateConfiguration((WeaviateVectorDbComponent)component).setHost((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((WeaviateVectorDbComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((WeaviateVectorDbComponent)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((WeaviateVectorDbComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyScheme": {
                    this.getOrCreateConfiguration((WeaviateVectorDbComponent)component).setProxyScheme((String)value);
                    return true;
                }
                case "scheme": {
                    this.getOrCreateConfiguration((WeaviateVectorDbComponent)component).setScheme((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((WeaviateVectorDbComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface WeaviateComponentBuilder
    extends ComponentBuilder<WeaviateVectorDbComponent> {
        default public WeaviateComponentBuilder apiKey(String apiKey) {
            this.doSetProperty("apiKey", apiKey);
            return this;
        }

        default public WeaviateComponentBuilder configuration(WeaviateVectorDbConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public WeaviateComponentBuilder host(String host) {
            this.doSetProperty("host", host);
            return this;
        }

        default public WeaviateComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public WeaviateComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public WeaviateComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public WeaviateComponentBuilder proxyScheme(String proxyScheme) {
            this.doSetProperty("proxyScheme", proxyScheme);
            return this;
        }

        default public WeaviateComponentBuilder scheme(String scheme) {
            this.doSetProperty("scheme", scheme);
            return this;
        }

        default public WeaviateComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    }
}

