/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.google.mail.GoogleMailClientFactory;
import org.apache.camel.component.google.mail.stream.GoogleMailStreamComponent;
import org.apache.camel.component.google.mail.stream.GoogleMailStreamConfiguration;

public interface GoogleMailStreamComponentBuilderFactory {
    public static GoogleMailStreamComponentBuilder googleMailStream() {
        return new GoogleMailStreamComponentBuilderImpl();
    }

    public static class GoogleMailStreamComponentBuilderImpl
    extends AbstractComponentBuilder<GoogleMailStreamComponent>
    implements GoogleMailStreamComponentBuilder {
        @Override
        protected GoogleMailStreamComponent buildConcreteComponent() {
            return new GoogleMailStreamComponent();
        }

        private GoogleMailStreamConfiguration getOrCreateConfiguration(GoogleMailStreamComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new GoogleMailStreamConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "applicationName": {
                    this.getOrCreateConfiguration((GoogleMailStreamComponent)component).setApplicationName((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((GoogleMailStreamComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "clientId": {
                    this.getOrCreateConfiguration((GoogleMailStreamComponent)component).setClientId((String)value);
                    return true;
                }
                case "delegate": {
                    this.getOrCreateConfiguration((GoogleMailStreamComponent)component).setDelegate((String)value);
                    return true;
                }
                case "labels": {
                    this.getOrCreateConfiguration((GoogleMailStreamComponent)component).setLabels((String)value);
                    return true;
                }
                case "markAsRead": {
                    this.getOrCreateConfiguration((GoogleMailStreamComponent)component).setMarkAsRead(((Boolean)value).booleanValue());
                    return true;
                }
                case "maxResults": {
                    this.getOrCreateConfiguration((GoogleMailStreamComponent)component).setMaxResults(((Long)value).longValue());
                    return true;
                }
                case "query": {
                    this.getOrCreateConfiguration((GoogleMailStreamComponent)component).setQuery((String)value);
                    return true;
                }
                case "raw": {
                    this.getOrCreateConfiguration((GoogleMailStreamComponent)component).setRaw(((Boolean)value).booleanValue());
                    return true;
                }
                case "scopes": {
                    this.getOrCreateConfiguration((GoogleMailStreamComponent)component).setScopes((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((GoogleMailStreamComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "clientFactory": {
                    ((GoogleMailStreamComponent)component).setClientFactory((GoogleMailClientFactory)value);
                    return true;
                }
                case "configuration": {
                    ((GoogleMailStreamComponent)component).setConfiguration((GoogleMailStreamConfiguration)value);
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((GoogleMailStreamComponent)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((GoogleMailStreamComponent)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessToken": {
                    this.getOrCreateConfiguration((GoogleMailStreamComponent)component).setAccessToken((String)value);
                    return true;
                }
                case "clientSecret": {
                    this.getOrCreateConfiguration((GoogleMailStreamComponent)component).setClientSecret((String)value);
                    return true;
                }
                case "refreshToken": {
                    this.getOrCreateConfiguration((GoogleMailStreamComponent)component).setRefreshToken((String)value);
                    return true;
                }
                case "serviceAccountKey": {
                    this.getOrCreateConfiguration((GoogleMailStreamComponent)component).setServiceAccountKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface GoogleMailStreamComponentBuilder
    extends ComponentBuilder<GoogleMailStreamComponent> {
        default public GoogleMailStreamComponentBuilder applicationName(String applicationName) {
            this.doSetProperty("applicationName", applicationName);
            return this;
        }

        default public GoogleMailStreamComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public GoogleMailStreamComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public GoogleMailStreamComponentBuilder delegate(String delegate) {
            this.doSetProperty("delegate", delegate);
            return this;
        }

        default public GoogleMailStreamComponentBuilder labels(String labels) {
            this.doSetProperty("labels", labels);
            return this;
        }

        default public GoogleMailStreamComponentBuilder markAsRead(boolean markAsRead) {
            this.doSetProperty("markAsRead", markAsRead);
            return this;
        }

        default public GoogleMailStreamComponentBuilder maxResults(long maxResults) {
            this.doSetProperty("maxResults", maxResults);
            return this;
        }

        default public GoogleMailStreamComponentBuilder query(String query) {
            this.doSetProperty("query", query);
            return this;
        }

        default public GoogleMailStreamComponentBuilder raw(boolean raw) {
            this.doSetProperty("raw", raw);
            return this;
        }

        default public GoogleMailStreamComponentBuilder scopes(String scopes) {
            this.doSetProperty("scopes", scopes);
            return this;
        }

        default public GoogleMailStreamComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public GoogleMailStreamComponentBuilder clientFactory(GoogleMailClientFactory clientFactory) {
            this.doSetProperty("clientFactory", clientFactory);
            return this;
        }

        default public GoogleMailStreamComponentBuilder configuration(GoogleMailStreamConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public GoogleMailStreamComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public GoogleMailStreamComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }

        default public GoogleMailStreamComponentBuilder accessToken(String accessToken) {
            this.doSetProperty("accessToken", accessToken);
            return this;
        }

        default public GoogleMailStreamComponentBuilder clientSecret(String clientSecret) {
            this.doSetProperty("clientSecret", clientSecret);
            return this;
        }

        default public GoogleMailStreamComponentBuilder refreshToken(String refreshToken) {
            this.doSetProperty("refreshToken", refreshToken);
            return this;
        }

        default public GoogleMailStreamComponentBuilder serviceAccountKey(String serviceAccountKey) {
            this.doSetProperty("serviceAccountKey", serviceAccountKey);
            return this;
        }
    }
}

