/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Signature;
import javax.crypto.KeyGenerator;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.pqc.PQCComponent;
import org.apache.camel.component.pqc.PQCConfiguration;
import org.apache.camel.component.pqc.PQCOperations;

public interface PqcComponentBuilderFactory {
    public static PqcComponentBuilder pqc() {
        return new PqcComponentBuilderImpl();
    }

    public static class PqcComponentBuilderImpl
    extends AbstractComponentBuilder<PQCComponent>
    implements PqcComponentBuilder {
        @Override
        protected PQCComponent buildConcreteComponent() {
            return new PQCComponent();
        }

        private PQCConfiguration getOrCreateConfiguration(PQCComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new PQCConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((PQCComponent)component).setConfiguration((PQCConfiguration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((PQCComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((PQCComponent)component).setOperation((PQCOperations)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((PQCComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "keyEncapsulationAlgorithm": {
                    this.getOrCreateConfiguration((PQCComponent)component).setKeyEncapsulationAlgorithm((String)value);
                    return true;
                }
                case "keyGenerator": {
                    this.getOrCreateConfiguration((PQCComponent)component).setKeyGenerator((KeyGenerator)value);
                    return true;
                }
                case "keyPair": {
                    this.getOrCreateConfiguration((PQCComponent)component).setKeyPair((KeyPair)value);
                    return true;
                }
                case "keyPairAlias": {
                    this.getOrCreateConfiguration((PQCComponent)component).setKeyPairAlias((String)value);
                    return true;
                }
                case "keyStore": {
                    this.getOrCreateConfiguration((PQCComponent)component).setKeyStore((KeyStore)value);
                    return true;
                }
                case "keyStorePassword": {
                    this.getOrCreateConfiguration((PQCComponent)component).setKeyStorePassword((String)value);
                    return true;
                }
                case "signatureAlgorithm": {
                    this.getOrCreateConfiguration((PQCComponent)component).setSignatureAlgorithm((String)value);
                    return true;
                }
                case "signer": {
                    this.getOrCreateConfiguration((PQCComponent)component).setSigner((Signature)value);
                    return true;
                }
                case "storeExtractedSecretKeyAsHeader": {
                    this.getOrCreateConfiguration((PQCComponent)component).setStoreExtractedSecretKeyAsHeader(((Boolean)value).booleanValue());
                    return true;
                }
                case "symmetricKeyAlgorithm": {
                    this.getOrCreateConfiguration((PQCComponent)component).setSymmetricKeyAlgorithm((String)value);
                    return true;
                }
                case "symmetricKeyLength": {
                    this.getOrCreateConfiguration((PQCComponent)component).setSymmetricKeyLength(((Integer)value).intValue());
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((PQCComponent)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((PQCComponent)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface PqcComponentBuilder
    extends ComponentBuilder<PQCComponent> {
        default public PqcComponentBuilder configuration(PQCConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public PqcComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public PqcComponentBuilder operation(PQCOperations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public PqcComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public PqcComponentBuilder keyEncapsulationAlgorithm(String keyEncapsulationAlgorithm) {
            this.doSetProperty("keyEncapsulationAlgorithm", keyEncapsulationAlgorithm);
            return this;
        }

        default public PqcComponentBuilder keyGenerator(KeyGenerator keyGenerator) {
            this.doSetProperty("keyGenerator", keyGenerator);
            return this;
        }

        default public PqcComponentBuilder keyPair(KeyPair keyPair) {
            this.doSetProperty("keyPair", keyPair);
            return this;
        }

        default public PqcComponentBuilder keyPairAlias(String keyPairAlias) {
            this.doSetProperty("keyPairAlias", keyPairAlias);
            return this;
        }

        default public PqcComponentBuilder keyStore(KeyStore keyStore) {
            this.doSetProperty("keyStore", keyStore);
            return this;
        }

        default public PqcComponentBuilder keyStorePassword(String keyStorePassword) {
            this.doSetProperty("keyStorePassword", keyStorePassword);
            return this;
        }

        default public PqcComponentBuilder signatureAlgorithm(String signatureAlgorithm) {
            this.doSetProperty("signatureAlgorithm", signatureAlgorithm);
            return this;
        }

        default public PqcComponentBuilder signer(Signature signer) {
            this.doSetProperty("signer", signer);
            return this;
        }

        default public PqcComponentBuilder storeExtractedSecretKeyAsHeader(boolean storeExtractedSecretKeyAsHeader) {
            this.doSetProperty("storeExtractedSecretKeyAsHeader", storeExtractedSecretKeyAsHeader);
            return this;
        }

        default public PqcComponentBuilder symmetricKeyAlgorithm(String symmetricKeyAlgorithm) {
            this.doSetProperty("symmetricKeyAlgorithm", symmetricKeyAlgorithm);
            return this;
        }

        default public PqcComponentBuilder symmetricKeyLength(int symmetricKeyLength) {
            this.doSetProperty("symmetricKeyLength", symmetricKeyLength);
            return this;
        }

        default public PqcComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public PqcComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }
    }
}

