/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import io.dapr.client.DaprPreviewClient;
import io.dapr.client.domain.HttpExtension;
import io.dapr.client.domain.StateOptions;
import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.dapr.DaprComponent;
import org.apache.camel.component.dapr.DaprConfiguration;
import org.apache.camel.component.dapr.StateOperation;

public interface DaprComponentBuilderFactory {
    public static DaprComponentBuilder dapr() {
        return new DaprComponentBuilderImpl();
    }

    public static class DaprComponentBuilderImpl
    extends AbstractComponentBuilder<DaprComponent>
    implements DaprComponentBuilder {
        @Override
        protected DaprComponent buildConcreteComponent() {
            return new DaprComponent();
        }

        private DaprConfiguration getOrCreateConfiguration(DaprComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new DaprConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configKeys": {
                    this.getOrCreateConfiguration((DaprComponent)component).setConfigKeys((List)value);
                    return true;
                }
                case "configStore": {
                    this.getOrCreateConfiguration((DaprComponent)component).setConfigStore((String)value);
                    return true;
                }
                case "configuration": {
                    ((DaprComponent)component).setConfiguration((DaprConfiguration)value);
                    return true;
                }
                case "contentType": {
                    this.getOrCreateConfiguration((DaprComponent)component).setContentType((String)value);
                    return true;
                }
                case "pubSubName": {
                    this.getOrCreateConfiguration((DaprComponent)component).setPubSubName((String)value);
                    return true;
                }
                case "topic": {
                    this.getOrCreateConfiguration((DaprComponent)component).setTopic((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((DaprComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "previewClient": {
                    this.getOrCreateConfiguration((DaprComponent)component).setPreviewClient((DaprPreviewClient)value);
                    return true;
                }
                case "bindingName": {
                    this.getOrCreateConfiguration((DaprComponent)component).setBindingName((String)value);
                    return true;
                }
                case "bindingOperation": {
                    this.getOrCreateConfiguration((DaprComponent)component).setBindingOperation((String)value);
                    return true;
                }
                case "concurrency": {
                    this.getOrCreateConfiguration((DaprComponent)component).setConcurrency((StateOptions.Concurrency)value);
                    return true;
                }
                case "consistency": {
                    this.getOrCreateConfiguration((DaprComponent)component).setConsistency((StateOptions.Consistency)value);
                    return true;
                }
                case "eTag": {
                    this.getOrCreateConfiguration((DaprComponent)component).setETag((String)value);
                    return true;
                }
                case "httpExtension": {
                    this.getOrCreateConfiguration((DaprComponent)component).setHttpExtension((HttpExtension)value);
                    return true;
                }
                case "key": {
                    this.getOrCreateConfiguration((DaprComponent)component).setKey((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((DaprComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "methodToInvoke": {
                    this.getOrCreateConfiguration((DaprComponent)component).setMethodToInvoke((String)value);
                    return true;
                }
                case "secretStore": {
                    this.getOrCreateConfiguration((DaprComponent)component).setSecretStore((String)value);
                    return true;
                }
                case "serviceToInvoke": {
                    this.getOrCreateConfiguration((DaprComponent)component).setServiceToInvoke((String)value);
                    return true;
                }
                case "stateOperation": {
                    this.getOrCreateConfiguration((DaprComponent)component).setStateOperation((StateOperation)value);
                    return true;
                }
                case "stateStore": {
                    this.getOrCreateConfiguration((DaprComponent)component).setStateStore((String)value);
                    return true;
                }
                case "verb": {
                    this.getOrCreateConfiguration((DaprComponent)component).setVerb((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((DaprComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface DaprComponentBuilder
    extends ComponentBuilder<DaprComponent> {
        default public DaprComponentBuilder configKeys(List<String> configKeys) {
            this.doSetProperty("configKeys", configKeys);
            return this;
        }

        default public DaprComponentBuilder configStore(String configStore) {
            this.doSetProperty("configStore", configStore);
            return this;
        }

        default public DaprComponentBuilder configuration(DaprConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public DaprComponentBuilder contentType(String contentType) {
            this.doSetProperty("contentType", contentType);
            return this;
        }

        default public DaprComponentBuilder pubSubName(String pubSubName) {
            this.doSetProperty("pubSubName", pubSubName);
            return this;
        }

        default public DaprComponentBuilder topic(String topic) {
            this.doSetProperty("topic", topic);
            return this;
        }

        default public DaprComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public DaprComponentBuilder previewClient(DaprPreviewClient previewClient) {
            this.doSetProperty("previewClient", previewClient);
            return this;
        }

        default public DaprComponentBuilder bindingName(String bindingName) {
            this.doSetProperty("bindingName", bindingName);
            return this;
        }

        default public DaprComponentBuilder bindingOperation(String bindingOperation) {
            this.doSetProperty("bindingOperation", bindingOperation);
            return this;
        }

        default public DaprComponentBuilder concurrency(StateOptions.Concurrency concurrency) {
            this.doSetProperty("concurrency", concurrency);
            return this;
        }

        default public DaprComponentBuilder consistency(StateOptions.Consistency consistency) {
            this.doSetProperty("consistency", consistency);
            return this;
        }

        default public DaprComponentBuilder eTag(String eTag) {
            this.doSetProperty("eTag", eTag);
            return this;
        }

        default public DaprComponentBuilder httpExtension(HttpExtension httpExtension) {
            this.doSetProperty("httpExtension", httpExtension);
            return this;
        }

        default public DaprComponentBuilder key(String key) {
            this.doSetProperty("key", key);
            return this;
        }

        default public DaprComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public DaprComponentBuilder methodToInvoke(String methodToInvoke) {
            this.doSetProperty("methodToInvoke", methodToInvoke);
            return this;
        }

        default public DaprComponentBuilder secretStore(String secretStore) {
            this.doSetProperty("secretStore", secretStore);
            return this;
        }

        default public DaprComponentBuilder serviceToInvoke(String serviceToInvoke) {
            this.doSetProperty("serviceToInvoke", serviceToInvoke);
            return this;
        }

        default public DaprComponentBuilder stateOperation(StateOperation stateOperation) {
            this.doSetProperty("stateOperation", stateOperation);
            return this;
        }

        default public DaprComponentBuilder stateStore(String stateStore) {
            this.doSetProperty("stateStore", stateStore);
            return this;
        }

        default public DaprComponentBuilder verb(String verb) {
            this.doSetProperty("verb", verb);
            return this;
        }

        default public DaprComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    }
}

