/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.wordpress.WordpressComponent;
import org.apache.camel.component.wordpress.WordpressConfiguration;
import org.apache.camel.component.wordpress.api.model.SearchCriteria;

public interface WordpressComponentBuilderFactory {
    public static WordpressComponentBuilder wordpress() {
        return new WordpressComponentBuilderImpl();
    }

    public static class WordpressComponentBuilderImpl
    extends AbstractComponentBuilder<WordpressComponent>
    implements WordpressComponentBuilder {
        @Override
        protected WordpressComponent buildConcreteComponent() {
            return new WordpressComponent();
        }

        private WordpressConfiguration getOrCreateConfiguration(WordpressComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new WordpressConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "apiVersion": {
                    this.getOrCreateConfiguration((WordpressComponent)component).setApiVersion((String)value);
                    return true;
                }
                case "configuration": {
                    ((WordpressComponent)component).setConfiguration((WordpressConfiguration)value);
                    return true;
                }
                case "criteria": {
                    this.getOrCreateConfiguration((WordpressComponent)component).setCriteria((Map)value);
                    return true;
                }
                case "force": {
                    this.getOrCreateConfiguration((WordpressComponent)component).setForce(((Boolean)value).booleanValue());
                    return true;
                }
                case "id": {
                    this.getOrCreateConfiguration((WordpressComponent)component).setId((Integer)value);
                    return true;
                }
                case "password": {
                    this.getOrCreateConfiguration((WordpressComponent)component).setPassword((String)value);
                    return true;
                }
                case "searchCriteria": {
                    this.getOrCreateConfiguration((WordpressComponent)component).setSearchCriteria((SearchCriteria)value);
                    return true;
                }
                case "url": {
                    this.getOrCreateConfiguration((WordpressComponent)component).setUrl((String)value);
                    return true;
                }
                case "user": {
                    this.getOrCreateConfiguration((WordpressComponent)component).setUser((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((WordpressComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((WordpressComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((WordpressComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface WordpressComponentBuilder
    extends ComponentBuilder<WordpressComponent> {
        default public WordpressComponentBuilder apiVersion(String apiVersion) {
            this.doSetProperty("apiVersion", apiVersion);
            return this;
        }

        default public WordpressComponentBuilder configuration(WordpressConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public WordpressComponentBuilder criteria(Map<String, Object> criteria) {
            this.doSetProperty("criteria", criteria);
            return this;
        }

        default public WordpressComponentBuilder force(boolean force) {
            this.doSetProperty("force", force);
            return this;
        }

        default public WordpressComponentBuilder id(Integer id) {
            this.doSetProperty("id", id);
            return this;
        }

        default public WordpressComponentBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public WordpressComponentBuilder searchCriteria(SearchCriteria searchCriteria) {
            this.doSetProperty("searchCriteria", searchCriteria);
            return this;
        }

        default public WordpressComponentBuilder url(String url) {
            this.doSetProperty("url", url);
            return this;
        }

        default public WordpressComponentBuilder user(String user) {
            this.doSetProperty("user", user);
            return this;
        }

        default public WordpressComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public WordpressComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public WordpressComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    }
}

