/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.util;

import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.annotation.BindyConverter;
import org.apache.camel.dataformat.bindy.annotation.DataField;
import org.apache.camel.dataformat.bindy.annotation.KeyValuePairField;

public final class ConverterUtils {
    private static final byte[] WINDOWS_RETURN_BYTES = new byte[]{13, 10};
    private static final byte[] UNIX_RETURN_BYTES = new byte[]{10};
    private static final byte[] MAC_RETURN_BYTES = new byte[]{13};
    private static final String CRLF = "\r\n";
    private static final String LINE_BREAK = "\n";
    private static final String CARRIAGE_RETURN = "\r";

    private ConverterUtils() {
    }

    public static char getCharDelimiter(String separator) {
        if (separator.equals("\\u0001")) {
            return '\u0001';
        }
        if (separator.equals("\\t") || separator.equals("\\u0009")) {
            return '\t';
        }
        if (separator.length() > 1) {
            return separator.charAt(separator.length() - 1);
        }
        return separator.charAt(0);
    }

    public static byte[] getByteReturn(String returnCharacter) {
        if (returnCharacter.equals("WINDOWS")) {
            return WINDOWS_RETURN_BYTES;
        }
        if (returnCharacter.equals("UNIX")) {
            return UNIX_RETURN_BYTES;
        }
        if (returnCharacter.equals("MAC")) {
            return MAC_RETURN_BYTES;
        }
        return returnCharacter.getBytes();
    }

    public static String getStringCarriageReturn(String returnCharacter) {
        if (returnCharacter.equals("WINDOWS")) {
            return CRLF;
        }
        if (returnCharacter.equals("UNIX")) {
            return LINE_BREAK;
        }
        if (returnCharacter.equals("MAC")) {
            return CARRIAGE_RETURN;
        }
        return returnCharacter;
    }

    public static FormattingOptions convert(DataField dataField, Class<?> clazz, BindyConverter converter, String locale) {
        return new FormattingOptions().forClazz(clazz).withPattern(dataField.pattern()).withLocale(locale).withTimezone(dataField.timezone()).withPrecision(dataField.precision()).withRounding(dataField.rounding()).withImpliedDecimalSeparator(dataField.impliedDecimalSeparator()).withDecimalSeparator(dataField.decimalSeparator()).withBindyConverter(converter).withGroupingSeparator(dataField.groupingSeparator());
    }

    public static FormattingOptions convert(KeyValuePairField dataField, Class<?> clazz, BindyConverter converter, String locale) {
        return new FormattingOptions().forClazz(clazz).withPattern(dataField.pattern()).withLocale(locale).withTimezone(dataField.timezone()).withPrecision(dataField.precision()).withBindyConverter(converter).withImpliedDecimalSeparator(dataField.impliedDecimalSeparator());
    }
}

