/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.util.concurrent.atomic.LongAdder;
import org.apache.camel.impl.converter.ConverterStatistics;

final class TypeConverterStatistics
implements ConverterStatistics {
    private boolean statisticsEnabled;
    private final LongAdder noopCounter = new LongAdder();
    private final LongAdder attemptCounter = new LongAdder();
    private final LongAdder missCounter = new LongAdder();
    private final LongAdder hitCounter = new LongAdder();
    private final LongAdder failedCounter = new LongAdder();

    TypeConverterStatistics() {
    }

    public long getNoopCounter() {
        return this.noopCounter.longValue();
    }

    public long getAttemptCounter() {
        return this.attemptCounter.longValue();
    }

    public long getHitCounter() {
        return this.hitCounter.longValue();
    }

    public long getMissCounter() {
        return this.missCounter.longValue();
    }

    public long getFailedCounter() {
        return this.failedCounter.longValue();
    }

    @Override
    public void incrementFailed() {
        if (this.statisticsEnabled) {
            this.failedCounter.increment();
        }
    }

    @Override
    public void incrementNoop() {
        if (this.statisticsEnabled) {
            this.noopCounter.increment();
        }
    }

    @Override
    public void incrementHit() {
        if (this.statisticsEnabled) {
            this.hitCounter.increment();
        }
    }

    @Override
    public void incrementMiss() {
        if (this.statisticsEnabled) {
            this.missCounter.increment();
        }
    }

    @Override
    public void incrementAttempt() {
        if (this.statisticsEnabled) {
            this.attemptCounter.increment();
        }
    }

    public void reset() {
        this.noopCounter.reset();
        this.attemptCounter.reset();
        this.hitCounter.reset();
        this.missCounter.reset();
        this.failedCounter.reset();
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    public String toString() {
        return String.format("TypeConverterRegistry utilization[noop=%s, attempts=%s, hits=%s, misses=%s, failures=%s]", this.getNoopCounter(), this.getAttemptCounter(), this.getHitCounter(), this.getMissCounter(), this.getFailedCounter());
    }
}

