/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.processor.ConvertBodyProcessor;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

public class DefaultFluentProducerTemplate
extends ServiceSupport
implements FluentProducerTemplate {
    private final ThreadLocal<Map<String, Object>> headers = new ThreadLocal();
    private final ThreadLocal<Object> body = new ThreadLocal();
    private final ThreadLocal<Endpoint> endpoint = new ThreadLocal();
    private final ThreadLocal<Supplier<Exchange>> exchangeSupplier = new ThreadLocal();
    private final ThreadLocal<Supplier<Processor>> processorSupplier = new ThreadLocal();
    private final ThreadLocal<Consumer<ProducerTemplate>> templateCustomizer = new ThreadLocal();
    private final CamelContext context;
    private final ClassValue<ConvertBodyProcessor> resultProcessors;
    private Endpoint defaultEndpoint;
    private int maximumCacheSize;
    private boolean eventNotifierEnabled;
    private volatile ProducerTemplate template;

    public DefaultFluentProducerTemplate(CamelContext context) {
        this.context = context;
        this.eventNotifierEnabled = true;
        this.resultProcessors = new ClassValue<ConvertBodyProcessor>(){

            @Override
            protected ConvertBodyProcessor computeValue(Class<?> type) {
                return new ConvertBodyProcessor(type);
            }
        };
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    public int getCurrentCacheSize() {
        if (this.template == null) {
            return 0;
        }
        return this.template.getCurrentCacheSize();
    }

    public void cleanUp() {
        if (this.template != null) {
            this.template.cleanUp();
        }
    }

    public void setDefaultEndpointUri(String endpointUri) {
        this.setDefaultEndpoint(this.getCamelContext().getEndpoint(endpointUri));
    }

    public Endpoint getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    public void setDefaultEndpoint(Endpoint defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    public int getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    public void setMaximumCacheSize(int maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
    }

    public boolean isEventNotifierEnabled() {
        return this.eventNotifierEnabled;
    }

    public void setEventNotifierEnabled(boolean eventNotifierEnabled) {
        this.eventNotifierEnabled = eventNotifierEnabled;
    }

    public FluentProducerTemplate clearAll() {
        this.clearBody();
        this.clearHeaders();
        return this;
    }

    public FluentProducerTemplate withHeader(String key, Object value) {
        Map<String, Object> map = this.headers.get();
        if (map == null) {
            map = new LinkedHashMap<String, Object>();
            this.headers.set(map);
        }
        map.put(key, value);
        return this;
    }

    public FluentProducerTemplate clearHeaders() {
        this.headers.remove();
        return this;
    }

    public FluentProducerTemplate withBody(Object body) {
        this.body.set(body);
        return this;
    }

    public FluentProducerTemplate withBodyAs(Object body, Class<?> type) {
        Object b = type != null ? this.context.getTypeConverter().convertTo(type, body) : body;
        this.body.set(b);
        return this;
    }

    public FluentProducerTemplate clearBody() {
        this.body.remove();
        return this;
    }

    public FluentProducerTemplate withTemplateCustomizer(Consumer<ProducerTemplate> templateCustomizer) {
        this.templateCustomizer.set(templateCustomizer);
        return this;
    }

    public FluentProducerTemplate withExchange(Exchange exchange) {
        return this.withExchange(() -> exchange);
    }

    public FluentProducerTemplate withExchange(Supplier<Exchange> exchangeSupplier) {
        this.exchangeSupplier.set(exchangeSupplier);
        return this;
    }

    public FluentProducerTemplate withProcessor(Processor processor) {
        return this.withProcessor(() -> processor);
    }

    public FluentProducerTemplate withProcessor(Supplier<Processor> processorSupplier) {
        this.processorSupplier.set(processorSupplier);
        return this;
    }

    public FluentProducerTemplate to(String endpointUri) {
        return this.to(this.context.getEndpoint(endpointUri));
    }

    public FluentProducerTemplate to(Endpoint endpoint) {
        this.endpoint.set(endpoint);
        return this;
    }

    public Object request() throws CamelExecutionException {
        return this.request(Object.class);
    }

    public <T> T request(Class<T> type) throws CamelExecutionException {
        Object result;
        Processor processorSupplier;
        if (this.exchangeSupplier.get() != null) {
            throw new IllegalArgumentException("withExchange not supported on FluentProducerTemplate.request method. Use send method instead.");
        }
        Endpoint target = this.target();
        Processor processor = processorSupplier = this.processorSupplier.get() != null ? this.processorSupplier.get().get() : this.defaultProcessor();
        if (type == Exchange.class) {
            result = this.template().request(target, processorSupplier);
        } else if (type == Message.class) {
            Exchange exchange = this.template().request(target, processorSupplier);
            result = exchange.getMessage();
        } else {
            Exchange exchange = this.template().send(target, ExchangePattern.InOut, processorSupplier, (Processor)this.resultProcessors.get(type));
            result = this.context.getTypeConverter().convertTo(type, ExchangeHelper.extractResultBody((Exchange)exchange, (ExchangePattern)exchange.getPattern()));
        }
        return (T)result;
    }

    public Future<Object> asyncRequest() {
        return this.asyncRequest(Object.class);
    }

    public <T> Future<T> asyncRequest(Class<T> type) {
        CompletableFuture result;
        Endpoint target = this.target();
        if (ObjectHelper.isNotEmpty(this.headers.get())) {
            HashMap<String, Object> headersCopy = new HashMap<String, Object>(this.headers.get());
            Object bodyCopy = this.body.get();
            result = this.template().asyncRequestBodyAndHeaders(target, bodyCopy, headersCopy, type);
        } else {
            Object bodyCopy = this.body.get();
            result = this.template().asyncRequestBody(target, bodyCopy, type);
        }
        return result;
    }

    public Exchange send() throws CamelExecutionException {
        Exchange exchange;
        Endpoint target = this.target();
        Exchange exchange2 = exchange = this.exchangeSupplier.get() != null ? this.exchangeSupplier.get().get() : null;
        if (exchange != null) {
            return this.template().send(target, exchange);
        }
        Processor processor = this.processorSupplier.get() != null ? this.processorSupplier.get().get() : this.defaultProcessor();
        return this.template().send(target, processor);
    }

    public Future<Exchange> asyncSend() {
        Exchange exchange;
        Endpoint target = this.target();
        Exchange exchange2 = exchange = this.exchangeSupplier.get() != null ? this.exchangeSupplier.get().get() : null;
        if (exchange != null) {
            return this.template().asyncSend(target, exchange);
        }
        Processor processor = this.processorSupplier.get() != null ? this.processorSupplier.get().get() : this.defaultAsyncProcessor();
        return this.template().asyncSend(target, processor);
    }

    public static FluentProducerTemplate on(CamelContext context) {
        return new DefaultFluentProducerTemplate(context);
    }

    private ProducerTemplate template() {
        ObjectHelper.notNull((Object)this.context, (String)"CamelContext");
        if (this.template == null) {
            this.template = this.context.createProducerTemplate(this.maximumCacheSize);
            if (this.defaultEndpoint != null) {
                this.template.setDefaultEndpoint(this.defaultEndpoint);
            }
            this.template.setEventNotifierEnabled(this.eventNotifierEnabled);
            if (this.templateCustomizer.get() != null) {
                this.templateCustomizer.get().accept(this.template);
            }
        }
        return this.template;
    }

    private Processor defaultProcessor() {
        return exchange -> {
            ObjectHelper.ifNotEmpty(this.headers.get(), exchange.getIn().getHeaders()::putAll);
            ObjectHelper.ifNotEmpty((Object)this.body.get(), arg_0 -> ((Message)exchange.getIn()).setBody(arg_0));
        };
    }

    private Processor defaultAsyncProcessor() {
        HashMap<String, Object> headersCopy = ObjectHelper.isNotEmpty(this.headers.get()) ? new HashMap<String, Object>(this.headers.get()) : null;
        Object bodyCopy = this.body.get();
        return exchange -> {
            ObjectHelper.ifNotEmpty((Object)headersCopy, exchange.getIn().getHeaders()::putAll);
            ObjectHelper.ifNotEmpty((Object)bodyCopy, arg_0 -> ((Message)exchange.getIn()).setBody(arg_0));
        };
    }

    private Endpoint target() {
        if (this.endpoint.get() != null) {
            return this.endpoint.get();
        }
        if (this.defaultEndpoint != null) {
            return this.defaultEndpoint;
        }
        throw new IllegalArgumentException("No endpoint configured on FluentProducerTemplate. You can configure an endpoint with to(uri)");
    }

    protected void doStart() throws Exception {
        if (this.template == null) {
            this.template = this.template();
        }
        ServiceHelper.startService((Object)this.template);
    }

    protected void doStop() throws Exception {
        this.clearAll();
        this.endpoint.remove();
        this.exchangeSupplier.remove();
        this.processorSupplier.remove();
        this.templateCustomizer.remove();
        ServiceHelper.stopService((Object)this.template);
    }
}

