/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.CamelInternalProcessorAdvice;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.OrderedComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedCamelInternalProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SharedCamelInternalProcessor.class);
    private final List<CamelInternalProcessorAdvice> advices = new ArrayList<CamelInternalProcessorAdvice>();

    public SharedCamelInternalProcessor(CamelInternalProcessorAdvice ... advices) {
        if (advices != null) {
            this.advices.addAll(Arrays.asList(advices));
            this.advices.sort((Comparator<CamelInternalProcessorAdvice>)OrderedComparator.get());
        }
    }

    public void process(Exchange exchange, final AsyncProcessor processor, final Processor resultProcessor) {
        AsyncProcessorAwaitManager awaitManager = ((ExtendedCamelContext)exchange.getContext().adapt(ExtendedCamelContext.class)).getAsyncProcessorAwaitManager();
        awaitManager.process(new AsyncProcessor(){

            public boolean process(Exchange exchange, AsyncCallback callback) {
                return SharedCamelInternalProcessor.this.process(exchange, callback, processor, resultProcessor);
            }

            public CompletableFuture<Exchange> processAsync(Exchange exchange) {
                AsyncCallbackToCompletableFutureAdapter callback = new AsyncCallbackToCompletableFutureAdapter((Object)exchange);
                this.process(exchange, (AsyncCallback)callback);
                return callback.getFuture();
            }

            public void process(Exchange exchange) throws Exception {
                throw new IllegalStateException();
            }
        }, exchange);
    }

    public boolean process(Exchange exchange, AsyncCallback originalCallback, AsyncProcessor processor, Processor resultProcessor) {
        if (processor == null || !this.continueProcessing(exchange, processor)) {
            originalCallback.done(true);
            return true;
        }
        Object[] states = new Object[this.advices.size()];
        for (int i = 0; i < this.advices.size(); ++i) {
            CamelInternalProcessorAdvice task = this.advices.get(i);
            try {
                Object state;
                states[i] = state = task.before(exchange);
                continue;
            }
            catch (Throwable e) {
                exchange.setException(e);
                originalCallback.done(true);
                return true;
            }
        }
        InternalCallback callback = new InternalCallback(states, exchange, originalCallback, resultProcessor);
        Object synchronous = exchange.removeProperty("CamelUnitOfWorkProcessSync");
        if (exchange.isTransacted() || synchronous != null) {
            if (LOG.isTraceEnabled()) {
                if (exchange.isTransacted()) {
                    LOG.trace("Transacted Exchange must be routed synchronously for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
                } else {
                    LOG.trace("Synchronous UnitOfWork Exchange must be routed synchronously for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
                }
            }
            try {
                processor.process(exchange);
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
        UnitOfWork uow = exchange.getUnitOfWork();
        InternalCallback async = callback;
        if (uow != null) {
            async = uow.beforeProcess((Processor)processor, exchange, (AsyncCallback)callback);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing exchange for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        }
        boolean sync = processor.process(exchange, (AsyncCallback)async);
        exchange.getContext().getReactiveExecutor().schedule(() -> {
            if (uow != null) {
                uow.afterProcess((Processor)processor, exchange, callback, sync);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Exchange processed and is continued routed asynchronously for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
            }
        }, "SharedCamelInternalProcessor - UnitOfWork - afterProcess - " + processor + " - " + exchange.getExchangeId());
        return sync;
    }

    protected boolean continueProcessing(Exchange exchange, AsyncProcessor processor) {
        boolean forceShutdown;
        boolean doStop;
        Object stop = exchange.getProperty("CamelRouteStop");
        if (stop != null && (doStop = ((Boolean)exchange.getContext().getTypeConverter().convertTo(Boolean.class, stop)).booleanValue())) {
            LOG.debug("Exchange is marked to stop routing: {}", (Object)exchange);
            return false;
        }
        if (processor instanceof Service && (forceShutdown = exchange.getContext().getShutdownStrategy().forceShutdown((Service)processor))) {
            String msg = "Run not allowed as ShutdownStrategy is forcing shutting down, will reject executing exchange: " + exchange;
            LOG.debug(msg);
            if (exchange.getException() == null) {
                exchange.setException((Throwable)new RejectedExecutionException(msg));
            }
            return false;
        }
        return true;
    }

    private final class InternalCallback
    implements AsyncCallback {
        private final Object[] states;
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final Processor resultProcessor;

        private InternalCallback(Object[] states, Exchange exchange, AsyncCallback callback, Processor resultProcessor) {
            this.states = states;
            this.exchange = exchange;
            this.callback = callback;
            this.resultProcessor = resultProcessor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(boolean doneSync) {
            if (this.resultProcessor != null) {
                try {
                    this.resultProcessor.process(this.exchange);
                }
                catch (Throwable e) {
                    this.exchange.setException(e);
                }
            }
            try {
                for (int i = SharedCamelInternalProcessor.this.advices.size() - 1; i >= 0; --i) {
                    CamelInternalProcessorAdvice task = (CamelInternalProcessorAdvice)SharedCamelInternalProcessor.this.advices.get(i);
                    Object state = this.states[i];
                    try {
                        task.after(this.exchange, state);
                        continue;
                    }
                    catch (Throwable e) {
                        this.exchange.setException(e);
                    }
                }
            }
            finally {
                this.exchange.getContext().getReactiveExecutor().callback(this.callback);
            }
        }
    }
}

