/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.AsyncProcessorSupport;

public class RemovePropertiesProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware {
    private String id;
    private final String pattern;
    private final String[] excludePattern;

    public RemovePropertiesProcessor(String pattern, String[] excludePattern) {
        this.pattern = pattern;
        this.excludePattern = excludePattern;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            exchange.removeProperties(this.pattern, this.excludePattern);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return "RemoveProperties(" + this.pattern + ")";
    }

    public String getTraceLabel() {
        return "removeProperties[" + this.pattern + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String[] getExcludePattern() {
        return this.excludePattern;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

