/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import org.apache.camel.CamelContext;
import org.apache.camel.impl.converter.BaseTypeConverterRegistry;
import org.apache.camel.impl.converter.FastAnnotationTypeConverterLoader;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.PackageScanClassResolver;

public class DefaultTypeConverter
extends BaseTypeConverterRegistry {
    private final boolean loadTypeConverters;

    public DefaultTypeConverter(PackageScanClassResolver resolver, Injector injector, FactoryFinder factoryFinder, boolean loadTypeConverters) {
        this(null, resolver, injector, factoryFinder, loadTypeConverters);
    }

    public DefaultTypeConverter(CamelContext camelContext, PackageScanClassResolver resolver, Injector injector, FactoryFinder factoryFinder, boolean loadTypeConverters) {
        super(camelContext, resolver, injector, factoryFinder);
        this.loadTypeConverters = loadTypeConverters;
    }

    public boolean allowNull() {
        return false;
    }

    public boolean isRunAllowed() {
        return true;
    }

    @Override
    protected void doInit() {
        super.doInit();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.loadCoreAndFastTypeConverters();
        if (this.loadTypeConverters) {
            int fast = this.typeMappings.size();
            this.loadTypeConverters();
            int additional = this.typeMappings.size() - fast;
            if (additional > 0) {
                this.log.info("Type converters loaded (fast: {}, scanned: {})", (Object)fast, (Object)additional);
                this.log.warn("Annotation scanning mode loaded {} type converters. Its recommended to migrate to @Converter(loader = true) for fast type converter mode.", (Object)additional);
            }
        }
    }

    @Override
    protected void initTypeConverterLoaders() {
        if (this.resolver != null) {
            this.typeConverterLoaders.add(new FastAnnotationTypeConverterLoader(this.resolver));
        }
    }
}

