/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.impl.engine.DurationRoutePolicy;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.support.PatternHelper;

@Metadata(label="bean", description="RoutePolicyFactory which executes for a duration and then triggers an action. This can be used to stop a set of routes after they have processed a number of messages, or has been running for N seconds.", annotations={"interfaceName=org.apache.camel.spi.RoutePolicyFactory"})
@Configurer(metadataOnly=true)
public class DurationRoutePolicyFactory
implements RoutePolicyFactory {
    @Metadata(description="Route pattern to select a set of routes (by their route id). By default all routes are selected")
    private String fromRouteId;
    @Metadata(description="Maximum seconds Camel is running before the action is triggered")
    private int maxSeconds;
    @Metadata(description="Maximum number of messages to process before the action is triggered")
    private int maxMessages;
    @Metadata(description="Action to perform", enums="STOP_CAMEL_CONTEXT,STOP_ROUTE,SUSPEND_ROUTE,SUSPEND_ALL_ROUTES", defaultValue="STOP_ROUTE")
    private DurationRoutePolicy.Action action = DurationRoutePolicy.Action.STOP_ROUTE;

    public RoutePolicy createRoutePolicy(CamelContext camelContext, String routeId, NamedNode route) {
        DurationRoutePolicy policy = null;
        if (this.fromRouteId == null || PatternHelper.matchPattern((String)routeId, (String)this.fromRouteId)) {
            policy = new DurationRoutePolicy(camelContext, routeId);
            policy.setMaxMessages(this.maxMessages);
            policy.setMaxSeconds(this.maxSeconds);
            policy.setAction(this.action);
        }
        return policy;
    }

    public String getFromRouteId() {
        return this.fromRouteId;
    }

    public void setFromRouteId(String fromRouteId) {
        this.fromRouteId = fromRouteId;
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(int maxMessages) {
        this.maxMessages = maxMessages;
    }

    public int getMaxSeconds() {
        return this.maxSeconds;
    }

    public void setMaxSeconds(int maxSeconds) {
        this.maxSeconds = maxSeconds;
    }

    public DurationRoutePolicy.Action getAction() {
        return this.action;
    }

    public void setAction(DurationRoutePolicy.Action action) {
        this.action = action;
    }
}

