/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.stepfunctions;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.stepfunctions.StepFunctions2Component;
import org.apache.camel.component.aws2.stepfunctions.StepFunctions2Configuration;
import org.apache.camel.component.aws2.stepfunctions.StepFunctions2Constants;
import org.apache.camel.component.aws2.stepfunctions.StepFunctions2Producer;
import org.apache.camel.component.aws2.stepfunctions.client.StepFunctions2ClientFactory;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.services.sfn.SfnClient;

@UriEndpoint(firstVersion="4.0.0", scheme="aws2-step-functions", title="AWS StepFunctions", syntax="aws2-step-functions:label", producerOnly=true, category={Category.CLOUD, Category.SERVERLESS}, headersClass=StepFunctions2Constants.class)
public class StepFunctions2Endpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    private SfnClient awsSfnClient;
    @UriParam
    private StepFunctions2Configuration configuration;

    public StepFunctions2Endpoint(String uri, Component component, StepFunctions2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public StepFunctions2Component getComponent() {
        return (StepFunctions2Component)super.getComponent();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new StepFunctions2Producer((Endpoint)this);
    }

    public void doStart() throws Exception {
        super.doStart();
        this.awsSfnClient = this.configuration.getAwsSfnClient() != null ? this.configuration.getAwsSfnClient() : StepFunctions2ClientFactory.getSfnClient(this.configuration).getSfnClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAwsSfnClient()) && this.awsSfnClient != null) {
            this.awsSfnClient.close();
        }
        super.doStop();
    }

    public StepFunctions2Configuration getConfiguration() {
        return this.configuration;
    }

    public SfnClient getAwsSfnClient() {
        return this.awsSfnClient;
    }

    public String getServiceUrl() {
        if (!this.configuration.isOverrideEndpoint()) {
            if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
                return this.configuration.getRegion();
            }
        } else if (ObjectHelper.isNotEmpty((String)this.configuration.getUriEndpointOverride())) {
            return this.configuration.getUriEndpointOverride();
        }
        return null;
    }

    public String getServiceProtocol() {
        return "step-functions";
    }
}

