/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.lambda;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.lambda.Lambda2Configuration;
import org.apache.camel.component.aws2.lambda.Lambda2Endpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.HealthCheckComponent;

@org.apache.camel.spi.annotations.Component(value="aws2-lambda")
public class Lambda2Component
extends HealthCheckComponent {
    @Metadata
    private Lambda2Configuration configuration = new Lambda2Configuration();

    public Lambda2Component() {
        this(null);
    }

    public Lambda2Component(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Lambda2Configuration configuration = this.configuration != null ? this.configuration.copy() : new Lambda2Configuration();
        Lambda2Endpoint endpoint = new Lambda2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        endpoint.setFunction(remaining);
        if (Boolean.FALSE.equals(configuration.isUseDefaultCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseProfileCredentialsProvider()) && Boolean.FALSE.equals(configuration.isUseSessionCredentials()) && configuration.getAwsLambdaClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("useDefaultCredentialsProvider is set to false, useProfileCredentialsProvider is set to false, useSessionCredentials is set to false, AmazonLambdaClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public Lambda2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Lambda2Configuration configuration) {
        this.configuration = configuration;
    }
}

