/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atom;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.parser.Parser;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Producer;
import org.apache.camel.component.atom.AtomComponent;
import org.apache.camel.component.atom.AtomEntryPollingConsumer;
import org.apache.camel.component.atom.AtomPollingConsumer;
import org.apache.camel.component.atom.AtomProducer;
import org.apache.camel.impl.DefaultPollingEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomEndpoint
extends DefaultPollingEndpoint {
    private Factory atomFactory;
    private String atomUri;
    private boolean splitEntries = true;

    public AtomEndpoint(String endpointUri, AtomComponent component, String atomUri) {
        super(endpointUri, (Component)component);
        this.atomUri = atomUri;
    }

    public boolean isSingleton() {
        return true;
    }

    public Producer createProducer() throws Exception {
        return new AtomProducer(this);
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        if (this.isSplitEntries()) {
            return new AtomEntryPollingConsumer(this);
        }
        return new AtomPollingConsumer(this);
    }

    public Document<Feed> parseDocument() throws Exception {
        String uri = this.getAtomUri();
        InputStream in = new URL(uri).openStream();
        return this.createAtomParser().parse(in, uri);
    }

    public OutputStream createProducerOutputStream() throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(this.getAtomUri()));
    }

    public Exchange createExchange(Document<Feed> document, Entry entry) {
        Exchange exchange = this.createExchange();
        exchange.getIn().setBody((Object)entry);
        exchange.setProperty("CamelAtomFeed", document);
        return exchange;
    }

    public Factory getAtomFactory() {
        if (this.atomFactory == null) {
            this.atomFactory = this.createAtomFactory();
        }
        return this.atomFactory;
    }

    public void setAtomFactory(Factory atomFactory) {
        this.atomFactory = atomFactory;
    }

    public String getAtomUri() {
        return this.atomUri;
    }

    public void setAtomUri(String atomUri) {
        this.atomUri = atomUri;
    }

    public boolean isSplitEntries() {
        return this.splitEntries;
    }

    public void setSplitEntries(boolean splitEntries) {
        this.splitEntries = splitEntries;
    }

    protected Factory createAtomFactory() {
        return Abdera.getNewFactory();
    }

    protected Parser createAtomParser() {
        return Abdera.getNewParser();
    }
}

