/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.spi;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

import org.apache.camel.CamelContext;

/**
 * A configurer for properties on a given object.
 * <p/>
 * This is used in Camel to have fast property configuration of Camel EIP patterns, which
 * are using property placeholders (eg {{foo}} style).
 */
public interface PropertyPlaceholderConfigurer extends PropertyConfigurer {

    /**
     * Gets the options which supports property placeholders and can be resolved.
     * This will be all the string based options.
     *
     * @return key/values of options
     */
    Map<String, Supplier<String>> getReadPropertyPlaceholderOptions(CamelContext camelContext);

    /**
     * To update an existing property using the function with the key/value and returning the changed value
     * This will be all the string based options.
     */
    Map<String, Consumer<String>> getWritePropertyPlaceholderOptions(CamelContext camelContext);

}
