/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.bind;

import junit.framework.TestCase;
import org.apache.camel.Exchange;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.DefaultParameterMappingStrategy;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.spring.bind.ExampleBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanInfoTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(BeanInfoTest.class);
    protected DefaultCamelContext camelContext = new DefaultCamelContext();
    protected Exchange exchange = new DefaultExchange(this.camelContext);
    protected DefaultParameterMappingStrategy strategy = new DefaultParameterMappingStrategy();
    protected ExampleBean bean = new ExampleBean();
    protected BeanInfo info;

    public void testFindsSingleMethodMatchingBody() throws Throwable {
        MethodInvocation invocation = this.info.createInvocation(this.bean, this.exchange);
        BeanInfoTest.assertNotNull((String)"Should have found a method invocation!", (Object)invocation);
        Object value = invocation.proceed();
        LOG.info((Object)("Value: " + value));
    }

    public void testBeanProcessor() throws Exception {
        BeanProcessor processor = new BeanProcessor((Object)this.bean, this.info);
        processor.process(this.exchange);
        LOG.info((Object)("Exchange is: " + this.exchange));
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.exchange.getIn().setBody("James");
        this.info = new BeanInfo(this.camelContext, this.bean.getClass(), this.strategy);
    }
}

