/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.List;
import org.apache.camel.CamelTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.TestSupport;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.SpringCamelContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class RoutingUsingCamelContextFactoryTest
extends TestSupport {
    protected String body = "<hello>world!</hello>";
    protected AbstractXmlApplicationContext applicationContext;

    public void testXMLRouteLoading() throws Exception {
        this.applicationContext = this.createApplicationContext();
        SpringCamelContext context = (SpringCamelContext)this.applicationContext.getBean("camel");
        this.assertValidContext(context);
        MockEndpoint resultEndpoint = (MockEndpoint)this.resolveMandatoryEndpoint(context, "mock:result");
        resultEndpoint.expectedBodiesReceived(this.body);
        CamelTemplate template = new CamelTemplate(context);
        template.send("seda:start", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setHeader("name", "James");
                in.setBody(RoutingUsingCamelContextFactoryTest.this.body);
            }
        });
        resultEndpoint.assertIsSatisfied();
    }

    protected void assertValidContext(SpringCamelContext context) {
        RoutingUsingCamelContextFactoryTest.assertNotNull((String)"No context found!", (Object)context);
        List<Route> routes = context.getRoutes();
        RoutingUsingCamelContextFactoryTest.assertNotNull((String)"Should have some routes defined", routes);
        RoutingUsingCamelContextFactoryTest.assertEquals((String)"Number of routes defined", (int)1, (int)routes.size());
    }

    protected ClassPathXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/routingUsingCamelContextFactory.xml");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.applicationContext != null) {
            this.applicationContext.destroy();
        }
    }
}

