/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;

public class XPathFilterTest
extends ContextTestSupport {
    protected String matchingBody = "<person name='James' city='London'/>";
    protected String notMatchingBody = "<person name='Hiram' city='Tampa'/>";

    public void testSendMatchingMessage() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(this.matchingBody);
        this.sendBody("direct:start", this.matchingBody);
        this.assertMockEndpointsSatisifed();
    }

    public void testSendNotMatchingMessage() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.sendBody("direct:start", this.notMatchingBody);
        this.assertMockEndpointsSatisifed();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").filter().xpath("/person[@name='James']").to("mock:result");
            }
        };
    }
}

