/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class ThrottlerTest
extends ContextTestSupport {
    protected int messageCount = 6;

    public void testSendLotsOfMessagesButOnly3GetThrough() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(3);
        resultEndpoint.setResultWaitTime(1000L);
        for (int i = 0; i < this.messageCount; ++i) {
            this.template.sendBody("seda:a", (Object)("<message>" + i + "</message>"));
        }
        resultEndpoint.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:a").throttler(3L).timePeriodMillis(30000L).to("mock:result");
            }
        };
    }
}

