/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.camel.util.ExchangeHelper;

public class SimulatorTest
extends ContextTestSupport {
    public void testReceivesFooResponse() throws Exception {
        this.assertRespondsWith("foo", "<hello>foo</hello>");
    }

    public void testReceivesBarResponse() throws Exception {
        this.assertRespondsWith("bar", "<hello>bar</hello>");
    }

    protected void assertRespondsWith(final String value, String containedText) throws InvalidPayloadException {
        Object response = this.template.request("direct:a", new Processor(){

            public void process(Exchange exchange) throws Exception {
                Message in = exchange.getIn();
                in.setBody("answer");
                in.setHeader("cheese", value);
            }
        });
        SimulatorTest.assertNotNull((String)"Should receive a response!", response);
        String text = ExchangeHelper.getMandatoryOutBody(response, String.class);
        this.log.info((Object)("Received: " + text));
        this.assertStringContains(text, containedText);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").recipientList(SimpleLanguage.simple("file:src/main/data/${in.headers.cheese}.xml"));
            }
        };
    }
}

