/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorType;

public class PipelineTest
extends ContextTestSupport {
    protected MockEndpoint resultEndpoint;

    public void testSendMessageThroughAPipeline() throws Exception {
        this.resultEndpoint.expectedBodiesReceived(4);
        Object results = this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(1);
                in.setHeader("foo", "bar");
            }
        });
        this.resultEndpoint.assertIsSatisfied();
        PipelineTest.assertEquals((String)"Result body", (Object)4, (Object)results.getOut().getBody());
    }

    public void testResultsReturned() throws Exception {
        Object exchange = this.template.send("direct:b", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody("Hello World");
            }
        });
        PipelineTest.assertEquals((Object)"Hello World", (Object)exchange.getOut().getBody());
        PipelineTest.assertEquals((Object)3, (Object)exchange.getOut().getHeader("copy-counter"));
    }

    public void testFaultStopsPipeline() throws Exception {
        Object exchange = this.template.send("direct:c", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody("Fault Message");
            }
        });
        PipelineTest.assertEquals((Object)"Fault Message", (Object)exchange.getFault().getBody());
        PipelineTest.assertEquals((Object)2, (Object)exchange.getFault().getHeader("copy-counter"));
        PipelineTest.assertEquals((Object)1, (Object)exchange.getOut().getHeader("copy-counter"));
    }

    public void testOnlyProperties() {
        Object exchange = this.template.send("direct:b", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setHeader("header", "headerValue");
            }
        });
        PipelineTest.assertEquals((Object)"headerValue", (Object)exchange.getOut().getHeader("header"));
        PipelineTest.assertEquals((Object)3, (Object)exchange.getOut().getHeader("copy-counter"));
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    protected RouteBuilder createRouteBuilder() {
        final Processor processor = new Processor(){

            public void process(Exchange exchange) {
                Integer number = exchange.getIn().getBody(Integer.class);
                if (number == null) {
                    number = 0;
                }
                number = number + 1;
                exchange.getOut().setBody(number);
            }
        };
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").pipeline("direct:x", "direct:y", "direct:z", "mock:result");
                this.from("direct:x").process(processor);
                this.from("direct:y").process(processor);
                this.from("direct:z").process(processor);
                ((ProcessorType)((ProcessorType)this.from("direct:b").process(new InToOut())).process(new InToOut())).process(new InToOut());
                ((ProcessorType)((ProcessorType)this.from("direct:c").process(new InToOut())).process(new InToFault())).process(new InToOut());
            }
        };
    }

    private final class InToFault
    implements Processor {
        private InToFault() {
        }

        public void process(Exchange exchange) throws Exception {
            exchange.getFault(true).setBody(exchange.getIn().getBody());
            Integer counter = exchange.getIn().getHeader("copy-counter", Integer.class);
            if (counter == null) {
                counter = 0;
            }
            exchange.getFault().setHeader("copy-counter", counter + 1);
        }
    }

    private final class InToOut
    implements Processor {
        private InToOut() {
        }

        public void process(Exchange exchange) throws Exception {
            exchange.getOut(true).copyFrom(exchange.getIn());
            Integer counter = exchange.getIn().getHeader("copy-counter", Integer.class);
            if (counter == null) {
                counter = 0;
            }
            exchange.getOut().setHeader("copy-counter", counter + 1);
        }
    }
}

