/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class LoadBalanceTest
extends ContextTestSupport {
    protected MockEndpoint x;
    protected MockEndpoint y;
    protected MockEndpoint z;

    protected void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
        this.z = this.getMockEndpoint("mock:z");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").loadBalance().roundRobin().to("mock:x", "mock:y", "mock:z");
            }
        };
    }

    public void testRoundRobin() throws Exception {
        String body = "<one/>";
        this.x.expectedBodiesReceived(body);
        MockEndpoint.expectsMessageCount(0, this.y, this.z);
        this.sendMessage("bar", body);
        this.assertMockEndpointsSatisifed();
        body = "<two/>";
        this.y.expectedBodiesReceived(body);
        MockEndpoint.expectsMessageCount(0, this.x, this.z);
        this.sendMessage("bar", body);
        this.assertMockEndpointsSatisifed();
        body = "<three/>";
        this.z.expectedBodiesReceived(body);
        MockEndpoint.expectsMessageCount(0, this.x, this.y);
        this.sendMessage("bar", body);
        this.assertMockEndpointsSatisifed();
    }

    protected void sendMessage(Object headerValue, Object body) throws Exception {
        this.template.sendBodyAndHeader("direct:start", body, "foo", headerValue);
    }
}

