/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.LoggingLevel;

public class DeadLetterChannelTest
extends ContextTestSupport {
    protected Endpoint<Exchange> startEndpoint;
    protected MockEndpoint deadEndpoint;
    protected MockEndpoint successEndpoint;
    protected int failUntilAttempt = 2;
    protected String body = "<hello>world!</hello>";

    public void testFirstFewAttemptsFail() throws Exception {
        this.successEndpoint.expectedBodiesReceived(this.body);
        this.successEndpoint.message(0).header("org.apache.camel.Redelivered").isEqualTo(true);
        this.successEndpoint.message(0).header("org.apache.camel.RedeliveryCounter").isEqualTo(1);
        this.deadEndpoint.expectedMessageCount(0);
        this.sendBody("direct:start", this.body);
        this.assertMockEndpointsSatisifed();
    }

    public void testLotsOfAttemptsFail() throws Exception {
        this.failUntilAttempt = 5;
        this.deadEndpoint.expectedBodiesReceived(this.body);
        this.deadEndpoint.message(0).header("org.apache.camel.Redelivered").isEqualTo(true);
        this.deadEndpoint.message(0).header("org.apache.camel.RedeliveryCounter").isEqualTo(2);
        this.successEndpoint.expectedMessageCount(0);
        this.sendBody("direct:start", this.body);
        this.assertMockEndpointsSatisifed();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.deadEndpoint = this.getMockEndpoint("mock:failed");
        this.successEndpoint = this.getMockEndpoint("mock:success");
    }

    protected RouteBuilder createRouteBuilder() {
        final Processor processor = new Processor(){

            public void process(Exchange exchange) {
                int attempt;
                Integer counter = exchange.getIn().getHeader("org.apache.camel.RedeliveryCounter", Integer.class);
                int n = attempt = counter == null ? 1 : counter + 1;
                if (attempt < DeadLetterChannelTest.this.failUntilAttempt) {
                    throw new RuntimeException("Failed to process due to attempt: " + attempt + " being less than: " + DeadLetterChannelTest.this.failUntilAttempt);
                }
                DeadLetterChannelTest.this.template.send("mock:success", exchange);
            }
        };
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorType)this.from("direct:start").errorHandler(this.deadLetterChannel("mock:failed").maximumRedeliveries(2).initialRedeliveryDelay(1L).loggingLevel(LoggingLevel.DEBUG))).process(processor);
            }
        };
    }
}

