/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.Serializable;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.util.ObjectHelper;

public class DataFormatTest
extends ContextTestSupport {
    public void testMarshalThenUnmarshalBean() throws Exception {
        MyBean bean = new MyBean();
        bean.name = "James";
        bean.counter = 5;
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedBodiesReceived(bean);
        this.template.sendBody("direct:start", (Object)bean);
        resultEndpoint.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").marshal().serialization().to("direct:marshalled");
                this.from("direct:marshalled").unmarshal().serialization().to("mock:result");
            }
        };
    }

    protected static class MyBean
    implements Serializable {
        public String name;
        public int counter;

        protected MyBean() {
        }

        public boolean equals(Object o) {
            if (o instanceof MyBean) {
                MyBean that = (MyBean)o;
                return ObjectHelper.equal(this.name, that.name) && ObjectHelper.equal(this.counter, that.counter);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() + this.counter;
        }
    }
}

