/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class BeanMethodHeartbeatTest
extends ContextTestSupport {
    protected MyService bean = new MyService("Beer");

    public void testHeartbeatsArrive() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMinimumMessageCount(1);
        resultEndpoint.assertIsSatisfied();
        ArrayList<Exchange> list = new ArrayList<Exchange>(resultEndpoint.getReceivedExchanges());
        this.log.debug((Object)("Received: " + list));
        Exchange exchange = (Exchange)list.get(0);
        this.log.debug((Object)("In: " + exchange.getIn()));
        this.log.debug((Object)("Out: " + exchange.getOut()));
        Map map = this.assertIsInstanceOf(Map.class, exchange.getIn().getBody());
        this.log.debug((Object)("Received: " + map));
    }

    protected Context createJndiContext() throws Exception {
        Context context = super.createJndiContext();
        context.bind("myService", (Object)this.bean);
        return context;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("bean:myService?method=status").to("mock:result");
            }
        };
    }

    public static class MyService {
        private String name;

        public MyService(String name) {
            this.name = name;
        }

        public Map status() {
            HashMap<String, Object> answer = new HashMap<String, Object>();
            answer.put("name", this.name);
            answer.put("time", new Date());
            return answer;
        }
    }
}

