/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.MyAggregationStrategy;

public class AggregatorTest
extends ContextTestSupport {
    protected int messageCount = 100;

    public void testSendingLotsOfMessagesGetAggregatedToTheLatestMessage() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedBodiesReceived("message:" + this.messageCount);
        for (int i = 1; i <= this.messageCount; ++i) {
            String body = "message:" + i;
            this.template.sendBodyAndHeader("direct:start", (Object)body, "cheese", (Object)123);
        }
        resultEndpoint.assertIsSatisfied();
    }

    public void testPredicate() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(this.messageCount / 5);
        for (int i = 1; i <= this.messageCount; ++i) {
            String body = "message:" + i;
            this.template.sendBodyAndHeader("direct:predicate", (Object)body, "cheese", (Object)123);
        }
        resultEndpoint.assertIsSatisfied();
    }

    public void testOneMessage() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:predicate", (Object)"test", "aggregated", (Object)5);
        resultEndpoint.assertIsSatisfied();
    }

    public void testBatchTimeoutExpiry() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.setSleepForEmptyTest(2000L);
        this.template.sendBodyAndHeader("direct:start", (Object)"message:1", "cheese", (Object)123);
        resultEndpoint.assertIsSatisfied();
    }

    public void xtestAggregatorNotAtStart() throws Exception {
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.message(0).header("visited").isNotNull();
        resultEndpoint.setSleepForEmptyTest(2000L);
        this.template.sendBodyAndHeader("seda:header", (Object)"message:1", "cheese", (Object)123);
        resultEndpoint.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").aggregator(this.header("cheese")).to("mock:result");
                ((ProcessorType)this.from("seda:header").setHeader("visited", this.constant(true))).aggregator(this.header("cheese")).to("mock:result");
                this.from("direct:predicate").aggregator(this.header("cheese"), new MyAggregationStrategy()).completedPredicate(this.header("aggregated").isEqualTo(5)).to("mock:result");
            }
        };
    }
}

