/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.groovy;

import groovy.lang.Binding;
import groovy.lang.Script;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.impl.ExpressionSupport;
import org.apache.camel.util.ExchangeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyExpression
extends ExpressionSupport<Exchange> {
    private Class<Script> scriptType;
    private String text;

    public GroovyExpression(Class<Script> scriptType, String text) {
        this.scriptType = scriptType;
        this.text = text;
    }

    public String toString() {
        return "groovy: " + this.text;
    }

    @Override
    protected String assertionFailureMessage(Exchange exchange) {
        return "groovy: " + this.text;
    }

    @Override
    public Object evaluate(Exchange exchange) {
        Script script = ExchangeHelper.newInstance(exchange, this.scriptType);
        this.configure(exchange, script);
        return script.run();
    }

    private void configure(Exchange exchange, Script script) {
        final Binding binding = script.getBinding();
        ExchangeHelper.populateVariableMap(exchange, new AbstractMap<String, Object>(){

            @Override
            public Object put(String key, Object value) {
                binding.setProperty(key, value);
                return null;
            }

            @Override
            public Set entrySet() {
                return Collections.EMPTY_SET;
            }
        });
    }
}

