/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RomeksExceptionTest
extends ContextTestSupport {
    private static final transient Log LOG = LogFactory.getLog(RomeksExceptionTest.class);

    public void testRouteA() throws Exception {
        this.assertErrorHandlingWorks("a");
    }

    public void testRouteB() throws Exception {
        this.assertErrorHandlingWorks("b");
    }

    protected void assertErrorHandlingWorks(String route) throws InterruptedException {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        MockEndpoint exceptionEndpoint = this.getMockEndpoint("mock:exception");
        resultEndpoint.expectedMessageCount(0);
        exceptionEndpoint.expectedBodiesReceived("<exception/>");
        this.template.sendBodyAndHeader("direct:start", (Object)"<body/>", "route", (Object)route);
        this.assertMockEndpointsSatisifed();
        List<Exchange> list = exceptionEndpoint.getReceivedExchanges();
        Exchange exchange = list.get(0);
        LOG.debug((Object)("Received: " + exchange.getIn()));
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        final Processor exceptionThrower = new Processor(){

            public void process(Exchange exchange) throws Exception {
                LOG.debug((Object)("About to throw exception on " + exchange));
                exchange.getIn().setBody("<exception/>");
                throw new IllegalArgumentException("Exception thrown intentionally.");
            }
        };
        return new RouteBuilder(){

            public void configure() {
                this.exception(IllegalArgumentException.class).to("mock:exception");
                this.from("direct:start").recipientList().simple("direct:${header.route}").to("mock:result");
                ((ProcessorType)((ProcessorType)this.from("direct:a").setBody(this.constant("<some-value/>"))).process(exceptionThrower)).to("mock:result");
                ((ProcessorType)((ProcessorType)this.from("direct:b").process(exceptionThrower)).setBody(this.constant("<some-value/>"))).to("mock:result");
            }
        };
    }
}

