/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.util.jndi.JndiTest;

public class RegistryTest
extends TestCase {
    protected JndiRegistry registry;

    public void testBind() throws Exception {
        List<String> foo = Arrays.asList("a", "b", "c");
        this.registry.bind("foo", foo);
        List list = this.registry.lookup("foo", List.class);
        RegistryTest.assertEquals((String)"Should be same!", foo, (Object)list);
    }

    public void testDefaultProviderAllowsValuesToBeCreatedInThePropertiesFile() throws Exception {
        Object value = this.registry.lookup("foo");
        RegistryTest.assertEquals((String)"lookup of foo", (Object)"bar", (Object)value);
    }

    public void testLookupOfUnknownName() throws Exception {
        Object value = this.registry.lookup("No such entry!");
        RegistryTest.assertNull((String)"Should not find anything!", (Object)value);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.registry = new JndiRegistry(JndiTest.createInitialContext());
    }
}

