/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.etl;

import java.util.List;
import org.apache.camel.Converter;
import org.apache.camel.example.etl.CustomerEntity;
import org.apache.camel.example.etl.PersonDocument;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.orm.jpa.JpaTemplate;

@Converter
public class CustomerTransformer {
    private static final transient Log LOG = LogFactory.getLog(CustomerTransformer.class);
    private JpaTemplate template;

    public CustomerTransformer(JpaTemplate template) {
        this.template = template;
    }

    @Converter
    public CustomerEntity toCustomer(PersonDocument doc) {
        String user = doc.getUser();
        CustomerEntity customer = this.findCustomerByName(user);
        customer.setFirstName(doc.getFirstName());
        customer.setSurname(doc.getLastName());
        customer.setCity(doc.getCity());
        LOG.debug((Object)("Created customer: " + customer));
        return customer;
    }

    protected CustomerEntity findCustomerByName(String user) {
        List list = this.template.find("select x from " + CustomerEntity.class.getName() + " x where x.userName = ?1", new Object[]{user});
        if (list.isEmpty()) {
            CustomerEntity answer = new CustomerEntity();
            answer.setUserName(user);
            this.template.persist((Object)answer);
            return answer;
        }
        return (CustomerEntity)list.get(0);
    }
}

