/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.cxf;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.example.cxf.Client;
import org.apache.camel.example.cxf.Server;
import org.apache.camel.example.jms.JmsBroker;
import org.apache.camel.impl.DefaultCamelContext;

public final class CamelCxfExample {
    private static final String ROUTER_ADDRESS = "http://localhost:9001/SoapContext/SoapPort";
    private static final String SERVICE_ADDRESS = "http://localhost:9000/SoapContext/SoapPort";
    private static final String SERVICE_CLASS = "serviceClass=org.apache.hello_world_soap_http.Greeter";
    private static final String WSDL_LOCATION = "wsdlURL=wsdl/hello_world.wsdl";
    private static final String SERVICE_NAME = "serviceName={http://apache.org/hello_world_soap_http}SOAPService";
    private static final String SOAP_OVER_HTTP_ROUTER = "portName={http://apache.org/hello_world_soap_http}SoapOverHttpRouter";
    private static final String SOAP_OVER_JMS = "portName={http://apache.org/hello_world_soap_http}SoapOverJms";
    private static final String ROUTER_ENDPOINT_URI = "cxf://http://localhost:9001/SoapContext/SoapPort?serviceClass=org.apache.hello_world_soap_http.Greeter&wsdlURL=wsdl/hello_world.wsdl&serviceName={http://apache.org/hello_world_soap_http}SOAPService&portName={http://apache.org/hello_world_soap_http}SoapOverHttpRouter&dataFormat=POJO";
    private static final String SERVICE_ENDPOINT_URI = "cxf://http://localhost:9000/SoapContext/SoapPort?serviceClass=org.apache.hello_world_soap_http.Greeter&wsdlURL=wsdl/hello_world.wsdl&serviceName={http://apache.org/hello_world_soap_http}SOAPService&portName={http://apache.org/hello_world_soap_http}SoapOverJms&dataFormat=POJO";

    private CamelCxfExample() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        JmsBroker broker = new JmsBroker();
        Server server = new Server();
        try {
            broker.start();
            server.start();
            context.addRoutes(new RouteBuilder(){

                public void configure() {
                    this.from(CamelCxfExample.ROUTER_ENDPOINT_URI).to(CamelCxfExample.SERVICE_ENDPOINT_URI);
                }
            });
            context.start();
            Client client = new Client("http://localhost:9001/SoapContext/SoapPort?wsdl");
            client.invoke();
            Thread.sleep(1000L);
            context.stop();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            server.stop();
            broker.stop();
            System.exit(0);
        }
    }
}

