/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stream;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.stream.StreamComponentException;
import org.apache.camel.component.stream.StreamExchange;
import org.apache.camel.component.stream.StreamMessage;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamConsumer
extends DefaultConsumer<StreamExchange> {
    private static final String TYPES = "in";
    private static final String INVALID_URI = "Invalid uri, valid form: 'stream:{in}'";
    private static final List<String> TYPES_LIST = Arrays.asList("in".split(","));
    private static final Log LOG = LogFactory.getLog(StreamConsumer.class);
    protected InputStream inputStream = System.in;
    Endpoint<StreamExchange> endpoint;
    private Map<String, String> parameters;
    private String uri;

    public StreamConsumer(Endpoint<StreamExchange> endpoint, Processor processor, String uri, Map<String, String> parameters) throws Exception {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.parameters = parameters;
        this.validateUri(uri);
        LOG.debug((Object)"Stream consumer created");
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (TYPES.equals(this.uri)) {
            this.inputStream = System.in;
        } else if ("file".equals(this.uri)) {
            this.inputStream = this.resolveStreamFromFile();
        } else if ("url".equals(this.uri)) {
            this.inputStream = this.resolveStreamFromUrl();
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(this.inputStream));
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                this.consume(line);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new StreamComponentException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new StreamComponentException(e);
        }
    }

    public void consume(Object o) throws Exception {
        StreamExchange exchange = this.endpoint.createExchange();
        exchange.setIn(new StreamMessage(o));
        this.getProcessor().process(exchange);
    }

    private InputStream resolveStreamFromUrl() throws IOException {
        String u = this.parameters.get("url");
        URL url = new URL(u);
        URLConnection c = url.openConnection();
        return c.getInputStream();
    }

    private InputStream resolveStreamFromFile() throws IOException {
        String fileName = this.parameters.get("file");
        fileName = fileName != null ? fileName.trim() : "_file";
        File f = new File(fileName);
        LOG.debug((Object)("About to read from file: " + f));
        f.createNewFile();
        return new FileInputStream(f);
    }

    private void validateUri(String uri) throws Exception {
        String[] s = uri.split(":");
        if (s.length < 2) {
            throw new Exception(INVALID_URI);
        }
        String[] t = s[1].split("\\?");
        if (t.length < 1) {
            throw new Exception(INVALID_URI);
        }
        this.uri = t[0].trim();
        if (!TYPES_LIST.contains(this.uri)) {
            throw new Exception(INVALID_URI);
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }
}

